/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ProcessingContext;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.completion.LimitedResultSet;
import org.jetbrains.plugins.ruby.model.completion.SymbolLookupElementLocation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyCodeInsightSettings;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyAbsoluteQualifiedNameInsertHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyQualifiedNameCompletionTarget;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyQualifiedNameInsertHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyQualifiedNamePrefixMatcher;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;
import org.jetbrains.plugins.ruby.ruby.model.completion.RubyCompletableSymbolService;
import org.jetbrains.plugins.ruby.ruby.model.completion.RubyCompletionScopeModifier;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyClassSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyConstantSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubySingletonSymbol;
import org.jetbrains.plugins.ruby.ruby.model.psi.reference.RubyQualifiedNameSymbolReference;

public class RubyCompletableQualifiedNameWrapper {
    protected final Project myProject;
    protected final SearchScope myResolveScope;
    protected final PsiElement myElement;
    protected final FQN myContainerFqn;
    protected final String myCompletionPrefix;
    protected final EnumSet<RubyQualifiedNameCompletionTarget> myCompletionTargets;
    protected final boolean myIsFuzzySearch;
    protected final boolean myIsGeneralCompletion;
    protected final Set<FQN> myProcessedFqns;

    RubyCompletableQualifiedNameWrapper(@NotNull RubyQualifiedNameSymbolReference reference) {
        if (reference == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(0);
        }
        this.myProcessedFqns = new HashSet<FQN>();
        this.myProject = reference.getElement().getProject();
        this.myResolveScope = reference.getElement().getResolveScope();
        this.myElement = reference.getElement();
        this.myContainerFqn = reference.getContainerFqn();
        this.myCompletionPrefix = StringUtil.substringBeforeLast((String)reference.getQualifiedName(), (String)"IntellijIdeaRulezzz");
        this.myCompletionTargets = EnumSet.copyOf(reference.getCompletionTargets());
        this.myIsFuzzySearch = RubyCodeInsightSettings.getInstance().isFuzzySearchCompletionMode();
        this.myIsGeneralCompletion = !StringUtil.trimLeading((String)this.myCompletionPrefix, (char)':').isEmpty();
    }

    public RubyCompletableQualifiedNameWrapper(@NotNull Project project, @NotNull SearchScope resolveScope, @NotNull PsiElement element, @NotNull FQN containerFqn, @NotNull String completionPrefix, @NotNull Set<RubyQualifiedNameCompletionTarget> completionTargets) {
        if (project == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(1);
        }
        if (resolveScope == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(3);
        }
        if (containerFqn == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(4);
        }
        if (completionPrefix == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(5);
        }
        if (completionTargets == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(6);
        }
        this.myProcessedFqns = new HashSet<FQN>();
        this.myProject = project;
        this.myResolveScope = resolveScope;
        this.myElement = element;
        this.myContainerFqn = containerFqn;
        this.myCompletionPrefix = completionPrefix;
        this.myCompletionTargets = EnumSet.copyOf(completionTargets);
        this.myIsFuzzySearch = RubyCodeInsightSettings.getInstance().isFuzzySearchCompletionMode();
        this.myIsGeneralCompletion = !StringUtil.trimLeading((String)this.myCompletionPrefix, (char)':').isEmpty();
    }

    public void addCompletionVariants(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(7);
        }
        if (context == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(8);
        }
        if (result == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(9);
        }
        RubyQualifiedNamePrefixMatcher prefixMatcher = new RubyQualifiedNamePrefixMatcher(this.myContainerFqn, this.myCompletionPrefix, this.myIsFuzzySearch);
        CompletionResultSet resultWithPrefix = result.withPrefixMatcher((PrefixMatcher)prefixMatcher);
        CompletionSorter sorter = CompletionService.getCompletionService().defaultSorter(parameters, (PrefixMatcher)prefixMatcher);
        int limit = Registry.intValue((String)"ide.completion.variant.limit", (int)1000) / 2;
        LimitedResultSet resultWithLimit = LimitedResultSet.wrap(resultWithPrefix, sorter, limit);
        this.addCompletionVariantsImpl(parameters, resultWithLimit);
    }

    protected void addCompletionVariantsImpl(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        List<SymbolLookupElementLocation> locations;
        if (parameters == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(10);
        }
        if (result == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(11);
        }
        if (this.myIsFuzzySearch && this.myCompletionTargets.isEmpty()) {
            return;
        }
        if (parameters.getInvocationCount() >= 2 || !this.myIsFuzzySearch || this.myIsGeneralCompletion) {
            locations = SymbolLookupElementLocation.getGeneralLocations();
        } else {
            locations = SymbolLookupElementLocation.getHighPriorityLocations();
            result.restartCompletionWhenNothingMatches();
        }
        SearchScope completionScope = RubyCompletionScopeModifier.getCompletionScope(this.myProject, this.myResolveScope);
        for (SymbolLookupElementLocation location : locations) {
            if (result.isStopped()) {
                result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(result.getPrefixMatcher().getPrefix().length()));
                result.addLookupAdvertisement(AnalysisBundle.message((String)"completion.not.all.variants.are.shown", (Object[])new Object[0]));
                return;
            }
            SearchScope locationScope = location.restrictSearchScope(this.myProject, completionScope, this.myElement);
            if (locationScope == null || locationScope == GlobalSearchScope.EMPTY_SCOPE) continue;
            this.processQualifiedNameSymbols(locationScope, location, parameters, result);
        }
    }

    protected void processQualifiedNameSymbols(@NotNull SearchScope searchScope, @NotNull SymbolLookupElementLocation location, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (searchScope == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(12);
        }
        if (location == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(13);
        }
        if (parameters == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(14);
        }
        if (result == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(15);
        }
        if (!this.myIsFuzzySearch || this.myCompletionTargets.contains((Object)RubyQualifiedNameCompletionTarget.CLASS)) {
            RubyClassSymbol.stream(this.myProject, searchScope).forEach(it -> this.processCompletionCandidate((RubyQualifiedNameSymbol)it, location, parameters, result));
        }
        if (!this.myIsFuzzySearch || this.myCompletionTargets.contains((Object)RubyQualifiedNameCompletionTarget.MODULE)) {
            RubyModuleSymbol.stream(this.myProject, searchScope).forEach(it -> this.processCompletionCandidate((RubyQualifiedNameSymbol)it, location, parameters, result));
        }
        if (!this.myIsFuzzySearch || this.myCompletionTargets.contains((Object)RubyQualifiedNameCompletionTarget.CONSTANT)) {
            RubyConstantSymbol.stream(this.myProject, searchScope).forEach(it -> this.processCompletionCandidate((RubyQualifiedNameSymbol)it, location, parameters, result));
        }
    }

    protected void processCompletionCandidate(@NotNull RubyQualifiedNameSymbol symbol, @NotNull SymbolLookupElementLocation location, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        FQN fqn;
        if (symbol == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(16);
        }
        if (location == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(17);
        }
        if (parameters == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(18);
        }
        if (result == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(19);
        }
        if (!this.myProcessedFqns.add(fqn = symbol.getFqn())) {
            return;
        }
        if (!this.isValidCompletionCandidate(fqn, location, parameters)) {
            return;
        }
        LookupElement lookupElement = RubyCompletableSymbolService.getInstance(this.myProject).asLookupElement(symbol, location);
        if (this.myCompletionPrefix.contains("::")) {
            if (symbol instanceof RubyClassSymbol || symbol instanceof RubyModuleSymbol || symbol instanceof RubySingletonSymbol) {
                lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)RubyCompletionGrouping.MODULE_OR_CLASS_IN_COLON_REF.getValue());
            } else if (symbol instanceof RubyConstantSymbol) {
                lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)RubyCompletionGrouping.CONSTS_IN_COLON_REF.getValue());
            }
        }
        if (this.myCompletionPrefix.startsWith("::")) {
            result.addElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, RubyAbsoluteQualifiedNameInsertHandler.INSTANCE));
        } else {
            result.addElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, RubyQualifiedNameInsertHandler.INSTANCE));
        }
    }

    protected boolean isValidCompletionCandidate(@NotNull FQN fqn, @NotNull SymbolLookupElementLocation location, @NotNull CompletionParameters parameters) {
        if (fqn == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(20);
        }
        if (location == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(21);
        }
        if (parameters == null) {
            RubyCompletableQualifiedNameWrapper.$$$reportNull$$$0(22);
        }
        if (parameters.getInvocationCount() >= 2 || !this.myIsFuzzySearch || this.myIsGeneralCompletion) {
            return true;
        }
        return location != SymbolLookupElementLocation.SDK || fqn.asList().size() <= 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionPrefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionTargets";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/qualifiedName/RubyCompletableQualifiedNameWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionVariants";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionVariantsImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "processQualifiedNameSymbols";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "processCompletionCandidate";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidCompletionCandidate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

