/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ml;

import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ml.RubyMLCompletionElementKind;
import org.jetbrains.plugins.ruby.statistic.RubyLookupUsageLocation;
import org.jetbrains.plugins.ruby.statistic.RubyLookupUsageLocationDescriptor;

public class RubyContextFeatureProvider
implements ContextFeatureProvider {
    @NotNull
    public String getName() {
        return "ruby";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull CompletionEnvironment environment) {
        if (environment == null) {
            RubyContextFeatureProvider.$$$reportNull$$$0(0);
        }
        HashMap<String, MLFeatureValue> result = new HashMap<String, MLFeatureValue>();
        RubyContextFeatureProvider.calculateKindFeature(environment, result);
        RubyContextFeatureProvider.calculateLookupUsageLocationFeature(environment, result);
        HashMap<String, MLFeatureValue> hashMap = result;
        if (hashMap == null) {
            RubyContextFeatureProvider.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static void calculateKindFeature(@NotNull CompletionEnvironment environment, @NotNull Map<String, MLFeatureValue> result) {
        PsiElement parent;
        if (environment == null) {
            RubyContextFeatureProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            RubyContextFeatureProvider.$$$reportNull$$$0(3);
        }
        if ((parent = (PsiElement)ObjectUtils.doIfNotNull((Object)environment.getParameters().getPosition().getParent(), PsiElement::getParent)) != null) {
            result.put("parent_kind", RubyContextFeatureProvider.getKindFeatureValue(parent));
            PsiElement grandparent = parent.getParent();
            if (grandparent != null) {
                result.put("grandparent_kind", RubyContextFeatureProvider.getKindFeatureValue(grandparent));
            }
        }
    }

    @NotNull
    private static MLFeatureValue getKindFeatureValue(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyContextFeatureProvider.$$$reportNull$$$0(4);
        }
        MLFeatureValue mLFeatureValue = MLFeatureValue.categorical((Enum)RubyMLCompletionElementKind.fromPsiElement(psiElement));
        if (mLFeatureValue == null) {
            RubyContextFeatureProvider.$$$reportNull$$$0(5);
        }
        return mLFeatureValue;
    }

    private static void calculateLookupUsageLocationFeature(@NotNull CompletionEnvironment environment, @NotNull Map<String, MLFeatureValue> result) {
        RubyLookupUsageLocation location;
        if (environment == null) {
            RubyContextFeatureProvider.$$$reportNull$$$0(6);
        }
        if (result == null) {
            RubyContextFeatureProvider.$$$reportNull$$$0(7);
        }
        if ((location = RubyLookupUsageLocationDescriptor.getLocationFromFile(environment.getParameters().getOriginalFile())) != null) {
            result.put("lookup_usage_location", MLFeatureValue.categorical((Enum)location));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/ml/RubyContextFeatureProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/ml/RubyContextFeatureProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateFeatures";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindFeatureValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateFeatures";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateKindFeature";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKindFeatureValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateLookupUsageLocationFeature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

