/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.method;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;

public class RubyMethodNameCompletionProvider
extends RubyTrackedCompletionProvider {
    public static final RubyMethodNameCompletionProvider INSTANCE = new RubyMethodNameCompletionProvider();

    private RubyMethodNameCompletionProvider() {
        super((Language)RubyLanguage.INSTANCE);
    }

    @Override
    protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiFile file;
        if (parameters == null) {
            RubyMethodNameCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RubyMethodNameCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            RubyMethodNameCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!((file = parameters.getOriginalFile()) instanceof RFile)) {
            return;
        }
        RMethod element = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(parameters.getOffset()), RMethod.class);
        if (element == null) {
            return;
        }
        RMethodHolder methodHolder = (RMethodHolder)PsiTreeUtil.getParentOfType((PsiElement)element, RMethodHolder.class);
        if (methodHolder == null) {
            return;
        }
        Symbol contextSymbol = SymbolUtil.getScopeContextWithCaching((PsiElement)element);
        if (contextSymbol != null) {
            SymbolUtil.processMembers(contextSymbol, Symbol.Filter.byTypes((TypeSet)Types.METHODS_LIKE).and(RubyCompletionProviderUtil.symbolNamePrefixFilter(result)), (PsiElement)element, (Processor<? super Symbol>)((Processor)method -> {
                Module module;
                String name = method.getName();
                RMethod existingMethod = methodHolder.findMethodByName(name);
                if (!(name == null || existingMethod != null && existingMethod != element || (module = method.getModule()) != null && RubyMethodNameCompletionProvider.isRailsRouteRegistration(module, method))) {
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement(name, null, null, true, AllIcons.Nodes.Method, null), (double)RubyCompletionGrouping.BOLDED.getValue()));
                }
                return true;
            }));
            RMethod existingInitialize = methodHolder.findMethodByName("initialize");
            if (existingInitialize == null || existingInitialize == element) {
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement("initialize", null, null, true, AllIcons.Nodes.Method, null), (double)RubyCompletionGrouping.BOLDED.getValue()));
            }
        }
    }

    private static boolean isRailsRouteRegistration(@NotNull Module module, @NotNull Symbol symbol) {
        VirtualFile file;
        if (module == null) {
            RubyMethodNameCompletionProvider.$$$reportNull$$$0(3);
        }
        if (symbol == null) {
            RubyMethodNameCompletionProvider.$$$reportNull$$$0(4);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)symbol.getPsiElement())) == null) {
            return false;
        }
        return RailsPaths.getInstance(module).findFiles("config/routes.rb").contains(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/method/RubyMethodNameCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionsTracked";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRailsRouteRegistration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

