/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhenCase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RubyThenCompletionFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        RPsiElement rContext = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)context);
        if (rContext == null) {
            return false;
        }
        RPsiElement parent = rContext;
        do {
            PsiElement callParent;
            if ((parent = parent.getParent()) instanceof RContainer) {
                return false;
            }
            RCompoundStatement compoundStatement = (RCompoundStatement)PsiTreeUtil.getParentOfType((PsiElement)rContext, RCompoundStatement.class);
            if (compoundStatement == null) {
                return false;
            }
            PsiElement sibling = RubyCompletionProviderUtil.getPrevNotWhitespaceSibling((PsiElement)compoundStatement);
            if (sibling instanceof PsiErrorElement) {
                sibling = RubyCompletionProviderUtil.getPrevNotWhitespaceSibling(sibling);
            }
            if (parent instanceof RIfStatement || parent instanceof RUnlessStatement) {
                RCondition condition = (RCondition)PsiTreeUtil.getParentOfType((PsiElement)rContext, RCondition.class);
                if (condition != null && condition.getFirstChild() != rContext && PsiTreeUtil.getDeepestLast((PsiElement)condition) == context) {
                    return true;
                }
                return sibling instanceof RCondition && PsiTreeUtil.getDeepestFirst((PsiElement)compoundStatement) == context;
            }
            if (parent instanceof RWhenCase) {
                return (sibling instanceof RExpression || sibling instanceof RListOfExpressions) && PsiTreeUtil.getDeepestFirst((PsiElement)compoundStatement) == context;
            }
            RCall call = RCallNavigator.getByRArgument((PsiElement)rContext);
            if (call != null && (callParent = call.getParent()) instanceof RListOfExpressions && callParent.getParent() instanceof RWhenCase) {
                return PsiTreeUtil.getDeepestLast((PsiElement)parent) == context;
            }
            if (!(parent instanceof RRescueBlock)) continue;
            return (sibling instanceof RExpression || sibling instanceof RBlockArgumentList) && PsiTreeUtil.getDeepestFirst((PsiElement)compoundStatement) == context;
        } while (parent != null && !(parent instanceof PsiFile));
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }
}

