/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyKeywordInBeginEndBlockCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RLoopStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBeginEndBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RubyOrderedKeywordCompletionFilter
extends RubyKeywordInBeginEndBlockCompletionFilter {
    private final Class myMarkerContainerClass;
    private final TokenSet mySiblingsToCheck;
    private final TokenSet myForbiddenAfterKeywords;
    private final TokenSet myForbiddenBeforeKeywords;
    private final boolean myCouldBeFirst;

    public RubyOrderedKeywordCompletionFilter(Class markerContainerClass, TokenSet elementsToCheckOrder, TokenSet forbiddenAfterKeywords, TokenSet forbiddenBeforeKeywords, boolean couldBeFirst) {
        this.myMarkerContainerClass = markerContainerClass;
        this.mySiblingsToCheck = elementsToCheckOrder;
        this.myForbiddenAfterKeywords = forbiddenAfterKeywords;
        this.myForbiddenBeforeKeywords = forbiddenBeforeKeywords;
        this.myCouldBeFirst = couldBeFirst;
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        if (!super.isAcceptable(element, context)) {
            return false;
        }
        ASTNode node = context.getNode();
        if (node == null) {
            return false;
        }
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{RBeginEndBlockStatement.class, RContainer.class, RLoopStatement.class, PsiFile.class});
        if (container != null && this.myMarkerContainerClass.isAssignableFrom(container.getClass())) {
            ASTNode firstChild;
            ASTNode parent = TreeUtil.findParent((ASTNode)node, (TokenSet)this.mySiblingsToCheck);
            if (parent == null || !PsiTreeUtil.isAncestor((PsiElement)container, (PsiElement)parent.getPsi(), (boolean)true)) {
                return this.myCouldBeFirst;
            }
            for (ASTNode prev = parent; prev != null; prev = prev.getTreePrev()) {
                firstChild = prev.getFirstChildNode();
                if (firstChild == null || !this.myForbiddenBeforeKeywords.contains(firstChild.getElementType())) continue;
                return false;
            }
            for (ASTNode next = parent.getTreeNext(); next != null; next = next.getTreeNext()) {
                firstChild = next.getFirstChildNode();
                if (firstChild == null || !this.myForbiddenAfterKeywords.contains(firstChild.getElementType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

