/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.exception;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;

public class RubyExceptionCompletionFilter
implements ElementFilter {
    public static boolean isInRescueExceptionsList(PsiElement element) {
        RRescueBlock block = (RRescueBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RRescueBlock.class);
        if (block == null) {
            return false;
        }
        RPsiElement blockExpression = block.getException();
        return PsiTreeUtil.isAncestor((PsiElement)blockExpression, (PsiElement)element, (boolean)false);
    }

    public static boolean isInRescueBody(PsiElement element) {
        RRescueBlock block = (RRescueBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RRescueBlock.class);
        if (block == null) {
            return false;
        }
        RCompoundStatement blockBody = block.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)blockBody, (PsiElement)element, (boolean)false) && !(PsiTreeUtil.skipWhitespacesBackward((PsiElement)blockBody) instanceof PsiErrorElement);
    }

    public static boolean isInRescue(PsiElement element) {
        RRescueBlock block = (RRescueBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RRescueBlock.class);
        return block != null;
    }

    public boolean isAcceptable(Object element, @Nullable PsiElement context) {
        if (!(element instanceof PsiElement)) {
            return false;
        }
        PsiElement psiElement = (PsiElement)element;
        return RubyExceptionCompletionFilter.isInRescueExceptionsList(psiElement);
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }
}

