/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RubyClassMember;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RubyClassMemberImpl;
import org.jetbrains.plugins.ruby.ruby.actions.override.RubyOverrideHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;

public final class RubyOverrideMethodCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final List<FQN> BLACKLISTED_CONTAINER_FQNS = List.of(CoreFqns.BASIC_OBJECT, CoreFqns.KERNEL, CoreFqns.OBJECT);
    private static final List<String> WHITELISTED_METHOD_NAMES = ContainerUtil.map(List.of(CoreFqns.BASIC_OBJECT_INITIALIZE, CoreFqns.BASIC_OBJECT_METHOD_MISSING, CoreFqns.KERNEL_CMP, CoreFqns.KERNEL_EQL, CoreFqns.KERNEL_EQQ, CoreFqns.KERNEL_HASH, CoreFqns.KERNEL_INITIALIZE_COPY, CoreFqns.KERNEL_INSPECT, CoreFqns.KERNEL_TO_ENUM, CoreFqns.KERNEL_TO_S), FQN::getShortName);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Symbol superSymbol;
        PsiElement defKeyword;
        PsiElement position;
        PsiElement prev;
        if (parameters == null) {
            RubyOverrideMethodCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            RubyOverrideMethodCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)(position = parameters.getPosition()))) == null) {
            return;
        }
        boolean isUserTypedSmthAlready = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)prev, RName.class) != null && TextUtil.isMethodName((String)prev.getText())) {
            defKeyword = PsiTreeUtil.prevVisibleLeaf((PsiElement)prev);
            isUserTypedSmthAlready = true;
            result = result.withPrefixMatcher(prev.getText());
        } else {
            defKeyword = prev;
        }
        if (defKeyword == null) {
            return;
        }
        if (!"def".equals(defKeyword.getText())) {
            return;
        }
        Document document = parameters.getEditor().getDocument();
        if (document.getLineNumber(parameters.getOffset()) != document.getLineNumber(defKeyword.getTextOffset())) {
            return;
        }
        RContainer method = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)position, RContainer.class);
        if (!(method instanceof RMethod)) {
            return;
        }
        PsiElement parent = RubyPsiUtil.getParentSkippingAllCompoundPsiElements((PsiElement)method);
        if (!(parent instanceof RClass)) {
            return;
        }
        Symbol parentSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)((RClass)parent));
        if (parentSymbol == null) {
            return;
        }
        StreamEx members = StreamEx.of(RubyOverrideHandler.createOverrideMembers(parentSymbol, position));
        if (isUserTypedSmthAlready && (superSymbol = (Symbol)RubySuperMethodsSearch.search((RMethod)method).findFirst()) != null && superSymbol.getPsiElement() instanceof RMethod) {
            members = members.append((Object)new RubyClassMemberImpl((RMethod)superSymbol.getPsiElement()));
        }
        FQN superFqn = Optional.ofNullable(parentSymbol.getInheritanceInfo(position).getSuperClass()).map(Symbol::getFQNWithNesting).map(fqn -> (FQN)ObjectUtils.nullizeByCondition((Object)fqn, BLACKLISTED_CONTAINER_FQNS::contains)).orElse(FQN.INVALID);
        CompletionResultSet resultSet = result;
        ((StreamEx)members.filter(member -> RubyCompletionProviderUtil.lookupStringShouldBeProcessed(member.getLookupItemString(), resultSet) && (!RubyOverrideMethodCompletionContributor.isBlacklisted(member) || RubyOverrideMethodCompletionContributor.isWhitelisted(member)))).map(member -> new RubyOverrideMethodLookupElement((RubyClassMember)member, FQN.same((FQN)superFqn, (String)member.getContainerClassName()))).forEach(arg_0 -> ((CompletionResultSet)resultSet).addElement(arg_0));
    }

    private static boolean isBlacklisted(@NotNull RubyClassMember member) {
        if (member == null) {
            RubyOverrideMethodCompletionContributor.$$$reportNull$$$0(2);
        }
        return BLACKLISTED_CONTAINER_FQNS.contains(FQN.of((String)member.getContainerClassName()));
    }

    private static boolean isWhitelisted(@NotNull RubyClassMember member) {
        if (member == null) {
            RubyOverrideMethodCompletionContributor.$$$reportNull$$$0(3);
        }
        return WHITELISTED_METHOD_NAMES.contains(member.getLookupItemString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyOverrideMethodCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isBlacklisted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitelisted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RubyOverrideMethodLookupElement
    extends RubyLookupElement {
        @NotNull
        private final RubyClassMember myMember;

        RubyOverrideMethodLookupElement(@NotNull RubyClassMember member, boolean bold) {
            if (member == null) {
                RubyOverrideMethodLookupElement.$$$reportNull$$$0(0);
            }
            super(member.getLookupItemString(), member.getPresentableParametersSignature(), member.getContainerClassName(), bold, member.getElement().getIcon(2), null);
            this.myMember = member;
        }

        @Override
        public void handleInsert(@NotNull InsertionContext context) {
            if (context == null) {
                RubyOverrideMethodLookupElement.$$$reportNull$$$0(1);
            }
            Document document = context.getDocument();
            Optional<PsiElement> defKeywordElement = Optional.ofNullable(context.getFile().findElementAt(context.getStartOffset())).map(PsiTreeUtil::prevVisibleLeaf);
            if (defKeywordElement.isEmpty()) {
                return;
            }
            document.deleteString(defKeywordElement.get().getTextOffset(), context.getTailOffset());
            context.commitDocument();
            RubyOverrideHandler.generateAndInsert(context.getProject(), context.getEditor(), context.getFile(), context.getEditor().getCaretModel().getOffset(), Collections.singletonList(this.myMember));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyOverrideMethodCompletionContributor$RubyOverrideMethodLookupElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

