/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.MethodInsertHandlerCreator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyAbstractMethodInsertHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyMethodInsertHandler;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.presentation.SymbolLookupUtil;

public class RubyMethodInsertHandlerCreator
implements MethodInsertHandlerCreator {
    public static final Logger LOG = Logger.getInstance(RubyMethodInsertHandlerCreator.class);
    private final String[] myLines;
    private final int myLine;
    private final int myColumn;
    private final Class<? extends MyRubyMethodInsertHandler> myClass;

    public RubyMethodInsertHandlerCreator(String[] lines, int line, int column, Class<? extends MyRubyMethodInsertHandler> handlerClass) {
        this.myLines = lines;
        this.myLine = line;
        this.myColumn = column;
        this.myClass = handlerClass;
    }

    @Override
    @Nullable
    public RubyMethodInsertHandler createInsertHandler(@Nullable RPsiElement methodDeclaration) {
        if (this.myClass == MyRubyMethodInsertHandler.class) {
            return new MyRubyMethodInsertHandler(methodDeclaration, this.myLines, this.myLine, this.myColumn);
        }
        if (this.myClass == MyAdditionalWhiteSpaceInsertHandler.class) {
            return new MyAdditionalWhiteSpaceInsertHandler(methodDeclaration, this.myLines, this.myLine, this.myColumn);
        }
        try {
            return this.myClass.getConstructor(RPsiElement.class, String[].class, Integer.TYPE, Integer.TYPE).newInstance(methodDeclaration, this.myLines, this.myLine, this.myColumn);
        }
        catch (Exception e) {
            LOG.error("Failed to create insert handler for:" + this.myClass.getName(), (Throwable)e);
            return null;
        }
    }

    public static class MyRubyMethodInsertHandler
    extends RubyAbstractMethodInsertHandler {
        @Nullable
        protected final RPsiElement myDeclaration;
        protected final String[] myLines;
        protected final int myLine;
        protected final int myColumn;

        public MyRubyMethodInsertHandler(@Nullable RPsiElement methodDeclaration, String[] lines, int line, int column) {
            super(methodDeclaration);
            this.myDeclaration = methodDeclaration;
            this.myLines = lines;
            this.myLine = line;
            this.myColumn = column;
        }

        @Override
        public void handleInsertMethodSignature(InsertionContext context, @Nullable RPsiElement methodDeclaration, String lookupItem) {
            SymbolLookupUtil.insertAndMoveCaret(this.myLines, this.myColumn, this.myLine, context);
        }
    }

    public static class MyAdditionalWhiteSpaceInsertHandler
    extends MyRubyMethodInsertHandler {
        public MyAdditionalWhiteSpaceInsertHandler(@Nullable RPsiElement methodDeclaration, String[] lines, int line, int column) {
            super(methodDeclaration, lines, line, column);
        }

        @Override
        public void handleInsertMethodSignature(InsertionContext context, @Nullable RPsiElement methodDeclaration, String lookupItem) {
            super.handleInsertMethodSignature(context, methodDeclaration, lookupItem);
            Editor editor = context.getEditor();
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
        }
    }
}

