/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;

public class RubyDoBlockInsertHandler
implements InsertHandler<LookupElement> {
    public static final RubyDoBlockInsertHandler INSTANCE = new RubyDoBlockInsertHandler();
    private static final String TEMPLATE_DO_BLOCK_CLOSING_END = "\nend";
    private static final String TEMPLATE_DO_BLOCK_AFTER_SPACE = " $END$\n  \nend";
    private static final String TEMPLATE_DO_BLOCK_AFTER_ENTER = "\n  $END$\nend";
    private static final String TEMPLATE_KEY = "do_block";
    private static final String TEMPLATE_GROUP = "Ruby";

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        int endIndent;
        int doIndent;
        if (context == null) {
            RubyDoBlockInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            RubyDoBlockInsertHandler.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        char completionChar = context.getCompletionChar();
        String templateCode = completionChar == ' ' ? TEMPLATE_DO_BLOCK_AFTER_SPACE : TEMPLATE_DO_BLOCK_AFTER_ENTER;
        PsiElement element = context.getFile().findElementAt(context.getStartOffset());
        RDoCodeBlock doBlock = (RDoCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RDoCodeBlock.class);
        if (doBlock != null && PsiUtilCore.getElementType((PsiElement)doBlock.getLastChild()) == RubyTokenTypes.kEND && (doIndent = DocumentUtil.getIndentLength((Document)context.getDocument(), (int)doBlock.getTextOffset())) == (endIndent = DocumentUtil.getIndentLength((Document)context.getDocument(), (int)doBlock.getLastChild().getTextOffset()))) {
            templateCode = templateCode.replace(TEMPLATE_DO_BLOCK_CLOSING_END, "");
        }
        Template template = manager.createTemplate(TEMPLATE_KEY, TEMPLATE_GROUP, templateCode);
        context.setAddCompletionChar(false);
        template.setToReformat(true);
        manager.startTemplate(context.getEditor(), template);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyDoBlockInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

