/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.CompletionResolveContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.MethodInsertHandlerCreator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RSymbolNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.presentation.SymbolLookupUtil;

public final class RubyCompletionProviderBase
extends RubyCompletionProvider {
    private static final MethodInsertHandlerCreator NO_SIGNATURE = SymbolLookupUtil.createNoSignatureHandlerCreator();
    public static final Predicate<Symbol> NAME_FILTER = symbol -> {
        String name = symbol.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        char c = name.charAt(0);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || '_' == c || '@' == c || '$' == c;
    };

    @Override
    public LookupElement createLookupItem(@NotNull Symbol symbol, String name, boolean bold, @Nullable Symbol typeSourceSymbol, RType originalType, boolean isInsertHandlerCanBeApplied, MethodInsertHandlerCreator insertHandler, FQN symbolFQN) {
        if (symbol == null) {
            RubyCompletionProviderBase.$$$reportNull$$$0(0);
        }
        if (symbolFQN == null) {
            return null;
        }
        ParamDefExpression paramdef = ParamDefManager.getInstance().getParamDefExpression(symbolFQN);
        if (paramdef != null) {
            return SymbolLookupUtil.createLookupItemImpl(symbol, originalType, name, bold, isInsertHandlerCanBeApplied, insertHandler != null ? insertHandler : NO_SIGNATURE);
        }
        return null;
    }

    @Override
    @Nullable
    protected Predicate<Symbol> getCompletionFilter(RPsiElement element) {
        boolean isCompletion;
        CompletionResolveContext completionResolveContext = ReferenceCompletionUtil.getContextType((PsiElement)element);
        if (completionResolveContext != null) {
            return completionResolveContext.getFilter(element);
        }
        String name = element.getName();
        boolean bl = isCompletion = name != null && name.endsWith("IntellijIdeaRulezzz");
        if (element instanceof RReference) {
            if (element instanceof RTopConstReference) {
                return Symbol.Filter.byTypes((TypeSet)SymbolUtil.getClassModuleConstantTypes());
            }
            return RReferenceBase.doesResolveToConstant((RReference)((RReference)element)) ? Symbol.Filter.byTypes((TypeSet)SymbolUtil.getClassModuleConstantTypes()).or(symbol -> isCompletion && Symbol.Filter.byTypes((TypeSet)SymbolUtil.getMethodTypes()).test(symbol)) : Symbol.Filter.byTypes((TypeSet)SymbolUtil.getMethodTypes());
        }
        if (element instanceof PsiNamedElement) {
            return NAME_FILTER;
        }
        return Symbol.Filter.ACCEPT_ALL;
    }

    @Override
    protected boolean acceptReswords(RPsiElement element) {
        if (ReferenceCompletionUtil.getContextType((PsiElement)element) != null) {
            return false;
        }
        if (element instanceof RIdentifier && ((RIdentifier)element).isParameterDeclaration() || element instanceof RConstantImpl && ((RConstantImpl)element).isInParameterPosition()) {
            return false;
        }
        if (RubyPsiUtil.isClassModuleOrMethodName((PsiElement)element)) {
            return false;
        }
        if (RSymbolNavigator.getSymbolByObject((PsiElement)element) != null) {
            return false;
        }
        if (element.getParent() instanceof RAliasStatement) {
            return false;
        }
        ParamDefReference reference = (ParamDefReference)ContainerUtil.findInstance((Object[])element.getReferences(), ParamDefReference.class);
        return reference == null || !reference.hasMatchingVariant();
    }

    @Override
    protected boolean acceptDoKeyword(RPsiElement element) {
        ParamDefReference reference = (ParamDefReference)ContainerUtil.findInstance((Object[])element.getReferences(), ParamDefReference.class);
        if (reference != null && reference.hasMatchingVariant()) {
            return reference.isOptional();
        }
        return RubyCompletionProviderBase.areReswordsAvailable(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyCompletionProviderBase", "createLookupItem"));
    }
}

