/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;

public final class RubyCompletionConfidence
extends CompletionConfidence {
    private static final String EMPTY_COMMENT = "#\\s*";
    private static final Pattern YARD_TAG_PATTERN = Pattern.compile("#\\s*@?\\w*");
    private static final Pattern YARD_LEFT_SQUARE_BRACKET_PATTERN = Pattern.compile("#\\s*@[\\s\\w]*\\[([a-zA-Z]\\w*,?\\s*)*");

    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        ASTNode node;
        if (contextElement == null) {
            RubyCompletionConfidence.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            RubyCompletionConfidence.$$$reportNull$$$0(1);
        }
        if ((node = contextElement.getNode()) != null) {
            int currentOffset = offset - node.getStartOffset() - 1;
            if (currentOffset < 0) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    RubyCompletionConfidence.$$$reportNull$$$0(2);
                }
                return threeState;
            }
            IElementType type = node.getElementType();
            CharSequence text = node.getChars();
            if (TokenBNF.tCOMMENTS.contains(type) && RubyCompletionConfidence.shouldSkipAutocompletionInComments(text, currentOffset)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    RubyCompletionConfidence.$$$reportNull$$$0(3);
                }
                return threeState;
            }
            if (TokenBNF.tVARS.contains(type)) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    RubyCompletionConfidence.$$$reportNull$$$0(4);
                }
                return threeState;
            }
        }
        ThreeState threeState = super.shouldSkipAutopopup(contextElement, psiFile, offset);
        if (threeState == null) {
            RubyCompletionConfidence.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    private static boolean shouldSkipAutocompletionInComments(@NotNull CharSequence text, int currentOffset) {
        CharSequence left;
        if (text == null) {
            RubyCompletionConfidence.$$$reportNull$$$0(6);
        }
        if (YARD_TAG_PATTERN.matcher(left = text.subSequence(0, currentOffset + 1)).matches()) {
            return false;
        }
        return !YARD_LEFT_SQUARE_BRACKET_PATTERN.matcher(left).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyCompletionConfidence";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyCompletionConfidence";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldSkipAutopopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipAutopopup";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipAutocompletionInComments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

