/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBBox;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyMethodInsertHandler;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

public final class RubyBlockInsertHandler
implements RubyMethodInsertHandler {
    private static final Logger LOG = Logger.getInstance(RubyBlockInsertHandler.class);
    private static final String RUBY_GROUP = "Ruby";
    private static final String TEMPLATE_NAME = "do_block";
    private static final String DO_BLOCK_TEMPLATE = " do |$ARGUMENTS$| \n  $END$\nend";
    private static final String ONE_LINE_BLOCK_TEMPLATE = " {|$ARGUMENTS$| $END$}";
    private static final String PROPERTY_KEY = "ruby.template.generate.doEndBlock";
    public static final RubyBlockInsertHandler ONE_LINE_BLOCK = new RubyBlockInsertHandler();
    private static final String[] defaultArguments = new String[]{""};
    private Balloon myBalloon;

    public void handleInsert(@NotNull InsertionContext context, @NotNull RubyLookupElement item) {
        if (context == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context.getEditor();
        VisualPosition visualPosition = editor.offsetToVisualPosition(editor.getCaretModel().getOffset());
        if (PropertiesComponent.getInstance().getValue(PROPERTY_KEY) == null) {
            PropertiesComponent.getInstance().setValue(PROPERTY_KEY, true);
        }
        String template = PropertiesComponent.getInstance().getBoolean(PROPERTY_KEY) ? ONE_LINE_BLOCK_TEMPLATE : DO_BLOCK_TEMPLATE;
        String builtTemplate = RubyBlockInsertHandler.buildTemplateString(template, defaultArguments);
        this.runTemplate(context, editor, builtTemplate, defaultArguments);
        this.showBalloon(context, visualPosition);
    }

    @Override
    public void handleInsertMethodSignature(InsertionContext context, RPsiElement method, String lookupItem) {
    }

    private void showBalloon(@NotNull InsertionContext context, final @NotNull VisualPosition visualPosition) {
        if (context == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(2);
        }
        if (visualPosition == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(3);
        }
        final Editor editor = context.getEditor();
        JPanel panel2 = this.createBalloonContent(context);
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)panel2, null).setSmallVariant(true);
        this.myBalloon = balloonBuilder.createBalloon();
        Disposer.register((Disposable)RubyPluginUtil.getUnloadAwareDisposable(context.getProject()), (Disposable)this.myBalloon);
        this.myBalloon.show((PositionTracker)new PositionTracker<Balloon>(this, (Component)editor.getContentComponent()){

            public RelativePoint recalculateLocation(@NotNull Balloon object) {
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                Point point = editor.visualPositionToXY(new VisualPosition(visualPosition.line, visualPosition.column));
                return new RelativePoint((Component)editor.getContentComponent(), point);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyBlockInsertHandler$1", "recalculateLocation"));
            }
        }, Balloon.Position.above);
    }

    private void closeBalloon() {
        if (this.myBalloon != null) {
            this.myBalloon.hide();
            Disposer.dispose((Disposable)this.myBalloon);
            this.myBalloon = null;
        }
    }

    private void closeBalloonWhenTemplateFinished(@NotNull TemplateState templateState) {
        if (templateState == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(4);
        }
        templateState.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    2.$$$reportNull$$$0(0);
                }
                RubyBlockInsertHandler.this.closeBalloon();
            }

            public void templateCancelled(Template template) {
                RubyBlockInsertHandler.this.closeBalloon();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyBlockInsertHandler$2", "templateFinished"));
            }
        });
    }

    private void changeBlockType(@NotNull InsertionContext context) {
        if (context == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(5);
        }
        try {
            Project project = context.getProject();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{context.getFile()}).run(() -> {
                Editor editor = context.getEditor();
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                int offset = context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET);
                RCodeBlock currentBlock = (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(offset - 1), RCodeBlock.class);
                if (currentBlock == null) {
                    return;
                }
                RBlockArgumentList blockParameters = currentBlock.getBlockArguments();
                if (blockParameters == null) {
                    return;
                }
                List arguments = blockParameters.getArguments();
                String[] argumentValues = (String[])defaultArguments.clone();
                for (int i = 0; i < arguments.size(); ++i) {
                    argumentValues[i] = ((RArgument)arguments.get(i)).getText();
                }
                PsiElement prev = currentBlock.getPrevSibling();
                if (prev instanceof PsiWhiteSpace) {
                    prev.delete();
                }
                currentBlock.delete();
                PsiDocumentManager.getInstance((Project)currentBlock.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                String templateCode = currentBlock instanceof RBraceCodeBlock ? RubyBlockInsertHandler.buildTemplateString(DO_BLOCK_TEMPLATE, argumentValues) : RubyBlockInsertHandler.buildTemplateString(ONE_LINE_BLOCK_TEMPLATE, argumentValues);
                this.runTemplate(context, editor, templateCode, argumentValues);
            });
        }
        catch (Throwable throwable) {
            this.closeBalloon();
            LOG.error(throwable);
        }
    }

    @NotNull
    private JPanel createBalloonContent(@NotNull InsertionContext context) {
        if (context == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(6);
        }
        NonFocusableCheckBox braceBlockCheckBox = new NonFocusableCheckBox(RBundle.message((String)"ruby.make.brace.block"));
        braceBlockCheckBox.setSelected(PropertiesComponent.getInstance().getBoolean(PROPERTY_KEY));
        braceBlockCheckBox.setMnemonic(66);
        braceBlockCheckBox.addActionListener(e -> {
            this.changeBlockType(context);
            PropertiesComponent.getInstance().setValue(PROPERTY_KEY, String.valueOf(!PropertiesComponent.getInstance().getBoolean(PROPERTY_KEY)));
        });
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder(null);
        panel2.add((Component)braceBlockCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)5), 0, 0));
        panel2.add((Component)JBBox.createVerticalBox(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private void runTemplate(@NotNull InsertionContext context, @NotNull Editor editor, @NotNull String templateCode, String @NotNull [] argumentDefaultValues) {
        if (context == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(9);
        }
        if (templateCode == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(10);
        }
        if (argumentDefaultValues == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(11);
        }
        Project project = context.getProject();
        Template template = TemplateManager.getInstance((Project)project).createTemplate(TEMPLATE_NAME, RUBY_GROUP, templateCode);
        for (int i = 0; i < argumentDefaultValues.length; ++i) {
            template.addVariable(RubyBlockInsertHandler.getArgumentName(i), (Expression)new TextExpression(argumentDefaultValues[i]), true);
        }
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        template.setToReformat(true);
        TemplateState templateState = manager.runTemplate(editor, template);
        this.closeBalloonWhenTemplateFinished(templateState);
    }

    private static String getArgumentName(int index) {
        return String.format("ARGUMENT_%s", index);
    }

    private static String buildTemplateString(@NotNull String template, String @NotNull [] argumentDefaultValues) {
        if (template == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(12);
        }
        if (argumentDefaultValues == null) {
            RubyBlockInsertHandler.$$$reportNull$$$0(13);
        }
        StringBuilder arguments = new StringBuilder();
        for (int i = 0; i < argumentDefaultValues.length; ++i) {
            arguments.append('$').append(RubyBlockInsertHandler.getArgumentName(i)).append('$');
            if (i >= argumentDefaultValues.length - 1) continue;
            arguments.append(", ");
        }
        return template.replace("$ARGUMENTS$", arguments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyBlockInsertHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateCode";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentDefaultValues";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyBlockInsertHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloonContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showBalloon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "closeBalloonWhenTemplateFinished";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "changeBlockType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonContent";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runTemplate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

