/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.codeFragment;

import com.intellij.codeInsight.codeFragment.CodeFragmentUtil;
import com.intellij.codeInsight.codeFragment.Position;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.WriteAccess;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.model.psi.reference.RubyNumberedParameterSymbolReference;

public class RCodeFragmentBuilder
extends RubyRecursiveElementVisitor {
    final Map<String, List<RIdentifier>> modifiedInsideMap = new HashMap<String, List<RIdentifier>>();
    final Set<String> inElements = new HashSet<String>();
    final Set<String> outElements = new HashSet<String>();
    final Set<String> modifiedFields = new HashSet<String>();
    private final int startOffset;
    private final int endOffset;
    private final RPsiElement myRoot;

    public RCodeFragmentBuilder(int start, int end, RPsiElement root) {
        this.startOffset = start;
        this.endOffset = end;
        this.myRoot = root;
    }

    public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
        if (rIdentifier == null) {
            RCodeFragmentBuilder.$$$reportNull$$$0(0);
        }
        if (rIdentifier.isNumberedParameter()) {
            ScopeHolder parameterScope;
            Position position = CodeFragmentUtil.getPosition((PsiElement)rIdentifier, (int)this.startOffset, (int)this.endOffset);
            if (position != Position.INSIDE) {
                return;
            }
            ScopeHolder rootScope = (ScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)this.myRoot, ScopeHolder.class, (boolean)false);
            if (rootScope == (parameterScope = RubyNumberedParameterSymbolReference.getScopeHolder(rIdentifier))) {
                this.inElements.add(rIdentifier.getText());
            }
            return;
        }
        if (!rIdentifier.isParameterDeclaration() && !rIdentifier.isLocalVariable()) {
            return;
        }
        Position position = CodeFragmentUtil.getPosition((PsiElement)rIdentifier, (int)this.startOffset, (int)this.endOffset);
        String name = rIdentifier.getName();
        RPsiPolyVariantReference reference = (RPsiPolyVariantReference)rIdentifier.getReference();
        if (position == Position.INSIDE) {
            Access access = UsageAnalyzer.createUsageAccess((RPsiElement)rIdentifier);
            if (access instanceof WriteAccess) {
                List<RIdentifier> list = this.modifiedInsideMap.get(name);
                if (list == null) {
                    list = new ArrayList<RIdentifier>();
                    this.modifiedInsideMap.put(name, list);
                }
                list.add(rIdentifier);
            }
            if (this.inElements.contains(name) || reference == null) {
                return;
            }
            ResolveResult[] resolveResultArray = reference.multiResolve(false);
            int n = resolveResultArray.length;
            for (int i = 0; i < n; ++i) {
                Position pos;
                ResolveResult result = resolveResultArray[i];
                PsiElement declaration = result.getElement();
                if (declaration == null || (pos = CodeFragmentUtil.getPosition((PsiElement)declaration, (int)this.startOffset, (int)this.endOffset)) != Position.BEFORE) continue;
                this.inElements.add(name);
                break;
            }
        }
        if (position == Position.AFTER) {
            if (this.outElements.contains(name) || reference == null) {
                return;
            }
            for (ResolveResult result : reference.multiResolve(false)) {
                PsiElement declaration = result.getElement();
                if (declaration == null) continue;
                Position pos = CodeFragmentUtil.getPosition((PsiElement)declaration, (int)this.startOffset, (int)this.endOffset);
                if (pos == Position.INSIDE) {
                    this.outElements.add(name);
                    break;
                }
                if (pos != Position.BEFORE) continue;
                List<RIdentifier> list = this.modifiedInsideMap.get(name);
                boolean modificationSeen = false;
                if (list == null) continue;
                for (RIdentifier modification : list) {
                    PsiReference modificationReference = modification.getReference();
                    if (modificationReference == null || !modificationReference.isReferenceTo(declaration)) continue;
                    this.outElements.add(name);
                    modificationSeen = true;
                    break;
                }
                if (modificationSeen) break;
            }
        }
    }

    public void visitRInstanceVariable(@NotNull RInstanceVariable rInstanceVariable) {
        if (rInstanceVariable == null) {
            RCodeFragmentBuilder.$$$reportNull$$$0(1);
        }
        this.visitRField((RField)rInstanceVariable);
    }

    public void visitRClassVariable(@NotNull RClassVariable rClassVariable) {
        if (rClassVariable == null) {
            RCodeFragmentBuilder.$$$reportNull$$$0(2);
        }
        this.visitRField((RField)rClassVariable);
    }

    private void visitRField(RField field) {
        Access access;
        if (CodeFragmentUtil.getPosition((PsiElement)field, (int)this.startOffset, (int)this.endOffset) == Position.INSIDE && (access = UsageAnalyzer.createUsageAccess((RPsiElement)field)) instanceof WriteAccess) {
            this.modifiedFields.add(field.getText());
        }
    }

    public Set<String> getInElements() {
        return this.inElements;
    }

    public Set<String> getOutElements() {
        return this.outElements;
    }

    public Set<String> getModifiedFields() {
        return this.modifiedFields;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rInstanceVariable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClassVariable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/codeFragment/RCodeFragmentBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRIdentifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRInstanceVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRClassVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

