/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.TypeInferenceInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubySymbolsLookupCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RVariableBase;

public final class RubyExceptionUtil {
    private RubyExceptionUtil() {
    }

    public static boolean isExceptionClass(RClass rubyClass) {
        Symbol classSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rubyClass);
        if (!(classSymbol instanceof ClassModuleSymbol)) {
            return false;
        }
        ClassModuleSymbol classModuleSymbol = (ClassModuleSymbol)classSymbol;
        Boolean isExceptionFQN = RubyExceptionUtil.isExceptionFQN(classModuleSymbol, (PsiElement)rubyClass);
        return isExceptionFQN != null ? isExceptionFQN : RubyExceptionUtil.isExceptionSymbol(classModuleSymbol, (PsiElement)rubyClass);
    }

    public static boolean isExceptionConstant(@NotNull RConstantImpl constant, @Nullable PsiElement invocationPoint) {
        ClassModuleSymbol classModuleSymbol;
        RSymbolType symbolType;
        Symbol symbol;
        RType type;
        if (constant == null) {
            RubyExceptionUtil.$$$reportNull$$$0(0);
        }
        if ((type = TypeInferenceInstance.getTypeOfRVariable((RVariableBase)constant, invocationPoint)) instanceof RModuleType) {
            type = ((RModuleType)type).getOriginalType();
        }
        Symbol resolvedSymbol = null;
        if (type instanceof RSymbolType && (symbol = (symbolType = (RSymbolType)type).getSymbol()) instanceof SingletonClassSymbol) {
            SingletonClassSymbol singletonClassSymbol = (SingletonClassSymbol)symbol;
            resolvedSymbol = singletonClassSymbol.getOriginSymbol();
        }
        return resolvedSymbol instanceof ClassModuleSymbol && RubyExceptionUtil.isExceptionSymbol(classModuleSymbol = (ClassModuleSymbol)resolvedSymbol, invocationPoint);
    }

    public static boolean isExceptionSymbol(@NotNull ClassModuleSymbol candidate, @Nullable PsiElement invocationPoint) {
        if (candidate == null) {
            RubyExceptionUtil.$$$reportNull$$$0(1);
        }
        Project project = candidate.getProject();
        HashSet<ClassModuleSymbol> visitedSymbols = new HashSet<ClassModuleSymbol>();
        ClassModuleSymbol symbol = candidate;
        Boolean foundException = null;
        while (symbol instanceof ClassModuleSymbol && visitedSymbols.add(symbol) && (foundException = RubyExceptionUtil.isExceptionFQN(symbol.getFQNWithNesting(), project, invocationPoint)) == null) {
            symbol = SymbolContainerUtil.getSymbolInheritanceInfo((Symbol)symbol, invocationPoint).getSuperClass();
        }
        boolean isException = Boolean.TRUE.equals(foundException);
        if (invocationPoint != null) {
            for (Symbol symbol2 : visitedSymbols) {
                RubySymbolsLookupCache.getInstance(project).registerExceptionFQN(invocationPoint, symbol2.getFQNWithNesting(), isException);
            }
        }
        return isException;
    }

    @Nullable
    private static Boolean isExceptionFQN(@NotNull ClassModuleSymbol candidate, @Nullable PsiElement invocationPoint) {
        if (candidate == null) {
            RubyExceptionUtil.$$$reportNull$$$0(2);
        }
        Project project = candidate.getProject();
        GlobalSearchScope scope = (GlobalSearchScope)ObjectUtils.coalesce((Object)((GlobalSearchScope)ObjectUtils.doIfNotNull((Object)candidate.getPsiElement(), PsiElement::getResolveScope)), (Object)GlobalSearchScope.allScope((Project)project));
        FQN superclass = candidate.getFQNWithNesting();
        HashSet<FQN> visitedFQNs = new HashSet<FQN>();
        Boolean foundException = null;
        while (superclass != null && visitedFQNs.add(superclass) && (foundException = RubyExceptionUtil.isExceptionFQN(superclass, project, invocationPoint)) == null) {
            Symbol symbol = SymbolUtil.findInNesting((Symbol)candidate, superclass, candidate.getPsiElement(), Types.MODULE_OR_CLASS_OR_CONSTANT, invocationPoint);
            superclass = (FQN)ObjectUtils.doIfNotNull((Object)symbol, Symbol::getFQNWithNesting);
        }
        if (foundException != null && invocationPoint != null) {
            for (FQN fqn : visitedFQNs) {
                RubySymbolsLookupCache.getInstance(candidate.getProject()).registerExceptionFQN(invocationPoint, fqn, foundException);
            }
        }
        return foundException;
    }

    @Nullable
    private static Boolean isExceptionFQN(@NotNull FQN fqn, @NotNull Project project, @Nullable PsiElement invocationPoint) {
        if (fqn == null) {
            RubyExceptionUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            RubyExceptionUtil.$$$reportNull$$$0(4);
        }
        if (fqn.getFullPath().equals("Exception")) {
            return true;
        }
        return invocationPoint != null ? RubySymbolsLookupCache.getInstance(project).isExceptionFQN(invocationPoint, fqn) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyExceptionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isExceptionConstant";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isExceptionSymbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isExceptionFQN";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

