/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.DynamicMethod;
import org.jetbrains.plugins.ruby.ruby.codeInsight.DynamicMethodList;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ResolveTargetDescriptor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyDynamicExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.YamlDynamicExtensionsLoader;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.computable.RPsiBasedTypeComputable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.computable.RSymbolBasedTypeComputable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;

public final class RubyDynamicExtensionsProvider
implements RubySymbolProvider,
RubyTypeProvider {
    private RubyDynamicExtensionsManager myExtensionsManager;

    public RType createTypeBySymbol(@NotNull Symbol symbol, @NotNull List<RType> typeArguments) {
        if (symbol == null) {
            RubyDynamicExtensionsProvider.$$$reportNull$$$0(0);
        }
        if (typeArguments == null) {
            RubyDynamicExtensionsProvider.$$$reportNull$$$0(1);
        }
        String shortName = symbol.getName();
        List<Pair<String, RSymbolBasedTypeComputable>> qualifiedNameAndTypePairs = this.getExtensionsManager().getIdentifierSymbolTypes(shortName);
        if (qualifiedNameAndTypePairs != null) {
            return RubyDynamicExtensionsProvider.getTypeFromPairs(qualifiedNameAndTypePairs, symbol);
        }
        return null;
    }

    public RType createTypeByRExpression(@NotNull RExpression expression) {
        PsiElement psiCommand;
        if (expression == null) {
            RubyDynamicExtensionsProvider.$$$reportNull$$$0(2);
        }
        if (expression instanceof RReference) {
            return this.createTypeForRef((RReference)expression);
        }
        if (expression instanceof RCall && (psiCommand = ((RCall)expression).getPsiCommand()) instanceof RReference) {
            return this.createTypeForRef((RReference)psiCommand);
        }
        return null;
    }

    @Nullable
    private RType createTypeForRef(@NotNull RReference ref) {
        RPsiElement value;
        if (ref == null) {
            RubyDynamicExtensionsProvider.$$$reportNull$$$0(3);
        }
        if ((value = ref.getValue()) instanceof RPossibleCall) {
            String shortName = ((RPossibleCall)value).getCommand();
            List<Pair<String, RPsiBasedTypeComputable>> qualifiedNameAndTypePairs = this.getExtensionsManager().getIdentifierPsiTypes(shortName);
            if (qualifiedNameAndTypePairs != null) {
                Symbol callSymbol = ResolveUtil.resolveToSymbolWithCaching(ref.getReference());
                if (callSymbol != null) {
                    FQN fqn = callSymbol.getFQNWithNesting();
                    for (Pair<String, RPsiBasedTypeComputable> fqnAndType : qualifiedNameAndTypePairs) {
                        RType type;
                        if (!FQN.same((FQN)fqn, (String)((String)fqnAndType.first)) || (type = ((RPsiBasedTypeComputable)fqnAndType.second).getType(callSymbol, (RExpression)ref)) == null) continue;
                        return type;
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    public RType getBlockParameterType(RPsiElement parameter, RPsiElement scope) {
        if (scope instanceof RBlockCall) {
            RPossibleCall callElement = ((RBlockCall)scope).getCall();
            String possibleCommand = callElement.getCommand();
            if (possibleCommand == null) {
                return null;
            }
            List<Pair<String, RSymbolBasedTypeComputable>> pairs = this.getExtensionsManager().getBlockVarSymbolTypes(possibleCommand);
            if (pairs != null) {
                PsiReference ref;
                if (callElement instanceof RCall) {
                    PsiElement command = callElement.getPsiCommand();
                    assert (command != null);
                    ref = command.getReference();
                } else {
                    ref = callElement.getReference();
                }
                Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(ref);
                if (symbol == null) {
                    return null;
                }
                return RubyDynamicExtensionsProvider.getTypeFromPairs(pairs, symbol);
            }
        }
        return null;
    }

    @Nullable
    private static RType getTypeFromPairs(List<Pair<String, RSymbolBasedTypeComputable>> qualifiedNameAndTypePairs, Symbol symbol) {
        FQN fqn = symbol.getFQNWithNesting();
        for (Pair<String, RSymbolBasedTypeComputable> fqnAndType : qualifiedNameAndTypePairs) {
            RType type;
            if (!FQN.same((FQN)fqn, (String)((String)fqnAndType.first)) || (type = ((RSymbolBasedTypeComputable)fqnAndType.second).getType(symbol)) == null) continue;
            return type;
        }
        return null;
    }

    @Override
    public boolean processDynamicSymbols(@NotNull Symbol symbol, @Nullable RPsiElement element, @NotNull FQN fqn, @NotNull SymbolPsiProcessor processor, @Nullable PsiElement invocationPoint) {
        DynamicMethodList methodList;
        if (symbol == null) {
            RubyDynamicExtensionsProvider.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            RubyDynamicExtensionsProvider.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            RubyDynamicExtensionsProvider.$$$reportNull$$$0(6);
        }
        if ((element instanceof RClass || element instanceof RModule) && (methodList = this.getExtensionsManager().getDynamicMethods(fqn)) != null) {
            RMethod defaultResolveTarget = null;
            Map<String, List<DynamicMethod>> name2methods = methodList.getNameMethodMapping((PsiElement)element);
            List<Object> methods = processor.getName() == null ? name2methods.values().stream().flatMap(it -> it.stream()).toList() : name2methods.getOrDefault(processor.getName(), Collections.emptyList());
            for (DynamicMethod dynamicMethod : methods) {
                DynamicSymbol symbol1;
                if (processor.getName() != null && !dynamicMethod.getName().equals(processor.getName())) continue;
                PsiElement target = RubyDynamicExtensionsProvider.findResolveTarget(symbol, dynamicMethod);
                if (target == null) {
                    if (defaultResolveTarget == null && (defaultResolveTarget = RContainerUtil.getMethodByName((RContainer)element, "included")) == null) {
                        defaultResolveTarget = element;
                    }
                    target = defaultResolveTarget;
                }
                if (processor.process((Symbol)(symbol1 = new DynamicSymbol(target, dynamicMethod.getName(), dynamicMethod.getType(), symbol)))) continue;
                return false;
            }
        }
        return true;
    }

    private RubyDynamicExtensionsManager getExtensionsManager() {
        if (this.myExtensionsManager == null) {
            this.myExtensionsManager = RubyDynamicExtensionsManager.getInstance();
            YamlDynamicExtensionsLoader.getInstance();
        }
        return this.myExtensionsManager;
    }

    @Nullable
    public static PsiElement findResolveTarget(Symbol symbol, DynamicMethod method) {
        ResolveTargetDescriptor resolveTarget = method.getResolveTarget();
        if (resolveTarget != null) {
            return RubyFQNUtil.findContainerByFQN(symbol.getProject(), Types.METHODS, FQN.Builder.fromString((String)resolveTarget.getQualifiedName()), null);
        }
        return null;
    }

    @Override
    public boolean acceptsSymbol(@NotNull Symbol symbol, @NotNull ContextImpl context) {
        if (symbol == null) {
            RubyDynamicExtensionsProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            RubyDynamicExtensionsProvider.$$$reportNull$$$0(8);
        }
        return symbol instanceof DynamicSymbol && symbol.getType() == Type.CLASS_METHOD && (context.getAccess().acceptInstance() || context instanceof ContextImpl.ExtendInIncludeContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyDynamicExtensionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeBySymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeByRExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeForRef";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processDynamicSymbols";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DynamicSymbol
    extends PsiElementSymbol<PsiElement> {
        DynamicSymbol(PsiElement psiElement, @Nullable String name, @NotNull Type type, @Nullable Symbol parent) {
            if (type == null) {
                DynamicSymbol.$$$reportNull$$$0(0);
            }
            super(psiElement, name, type, parent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyDynamicExtensionsProvider$DynamicSymbol", "<init>"));
        }
    }
}

