/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.DynamicMethodList;
import org.jetbrains.plugins.ruby.ruby.codeInsight.DynamicMethodsTable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ResolveTargetDescriptor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.computable.RPsiBasedTypeComputable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.computable.RSymbolBasedTypeComputable;

public class RubyDynamicExtensionsManager {
    private final DynamicMethodsTable myDynamicMethods = new DynamicMethodsTable();
    private final Map<String, List<Pair<String, RSymbolBasedTypeComputable>>> myNameToImplicitIdentifierSymbolTypes = new HashMap<String, List<Pair<String, RSymbolBasedTypeComputable>>>();
    private final Map<String, List<Pair<String, RPsiBasedTypeComputable>>> myNameToImplicitIdentifierPsiTypes = new HashMap<String, List<Pair<String, RPsiBasedTypeComputable>>>();
    private final Map<String, List<Pair<String, RSymbolBasedTypeComputable>>> myNameToBlockVariableTypes = new HashMap<String, List<Pair<String, RSymbolBasedTypeComputable>>>();

    public static RubyDynamicExtensionsManager getInstance() {
        return (RubyDynamicExtensionsManager)ApplicationManager.getApplication().getService(RubyDynamicExtensionsManager.class);
    }

    public void registerDynamicMethods(@NonNls String moduleName, @NotNull Type methodType, @Nullable ResolveTargetDescriptor resolveTarget, @Nullable GemDependency requiredGem, String ... methodNames) {
        if (methodType == null) {
            RubyDynamicExtensionsManager.$$$reportNull$$$0(0);
        }
        this.myDynamicMethods.registerDynamicMethods(moduleName, methodType, resolveTarget, requiredGem, methodNames);
    }

    public void addBlockVariableComputableType(@NonNls String methodQualifiedName, RSymbolBasedTypeComputable computable) {
        RubyDynamicExtensionsManager.addToMap(methodQualifiedName, computable, this.myNameToBlockVariableTypes);
    }

    public void addImplicitMethodReturnType(@NonNls String methodQualifiedName, @NonNls String typeBirthClassQualifiedName) {
        RubyDynamicExtensionsManager.addToMap(methodQualifiedName, typeBirthClassQualifiedName, this.myNameToImplicitIdentifierSymbolTypes);
    }

    public void addImplicitMethodReturnComputableType(@NonNls String methodQualifiedName, @NonNls RSymbolBasedTypeComputable typeComputable) {
        RubyDynamicExtensionsManager.addToMap(methodQualifiedName, typeComputable, this.myNameToImplicitIdentifierSymbolTypes);
    }

    public void addImplicitMethodReturnComputableType(@NonNls String methodQualifiedName, @NonNls RPsiBasedTypeComputable typeComputable) {
        RubyDynamicExtensionsManager.addToMap(methodQualifiedName, typeComputable, this.myNameToImplicitIdentifierPsiTypes);
    }

    public void addBlockVariableType(@NonNls String methodQualifiedName, @NonNls String typeBirthClassQualifiedName) {
        RubyDynamicExtensionsManager.addToMap(methodQualifiedName, typeBirthClassQualifiedName, this.myNameToBlockVariableTypes);
    }

    public void addDynamicClassType(@NonNls String classQualifiedName) {
        RSymbolBasedTypeComputable typeComputable = RTypeUtil.createDynamicTypeComputable(RTypeUtil.createEmptyTypeComputable());
        RubyDynamicExtensionsManager.addToMap(classQualifiedName, typeComputable, this.myNameToImplicitIdentifierSymbolTypes);
    }

    public void addDynamicClassType(@NonNls String classQualifiedName, @NotNull RSymbolBasedTypeComputable memberReturnTypeComputable) {
        if (memberReturnTypeComputable == null) {
            RubyDynamicExtensionsManager.$$$reportNull$$$0(1);
        }
        RSymbolBasedTypeComputable typeComputable = RTypeUtil.createDynamicTypeComputable(memberReturnTypeComputable);
        RubyDynamicExtensionsManager.addToMap(classQualifiedName, typeComputable, this.myNameToImplicitIdentifierSymbolTypes);
    }

    public void addRecursiveDynamicClassType(@NonNls String classQualifiedName) {
        this.addDynamicClassType(classQualifiedName, RTypeUtil.createEmptyTypeComputable());
    }

    @TestOnly
    public void clear() {
        this.myDynamicMethods.clear();
        this.myNameToBlockVariableTypes.clear();
        this.myNameToImplicitIdentifierSymbolTypes.clear();
        this.myNameToImplicitIdentifierPsiTypes.clear();
    }

    @Nullable
    public List<Pair<String, RSymbolBasedTypeComputable>> getIdentifierSymbolTypes(String shortName) {
        return this.myNameToImplicitIdentifierSymbolTypes.get(shortName);
    }

    @Nullable
    public List<Pair<String, RPsiBasedTypeComputable>> getIdentifierPsiTypes(String shortName) {
        return this.myNameToImplicitIdentifierPsiTypes.get(shortName);
    }

    @Nullable
    public List<Pair<String, RSymbolBasedTypeComputable>> getBlockVarSymbolTypes(String commandName) {
        return this.myNameToBlockVariableTypes.get(commandName);
    }

    @Nullable
    public DynamicMethodList getDynamicMethods(FQN fqn) {
        return this.myDynamicMethods.getMethodListsBy(fqn);
    }

    private static <T> void addToMap(String methodQualifiedName, T computable, Map<String, List<Pair<String, T>>> map) {
        FQN fqn = FQN.Builder.fromString((String)methodQualifiedName);
        String shortMethodName = fqn.getShortName();
        List<Pair<String, T>> pairs = map.get(shortMethodName);
        if (pairs == null) {
            pairs = new ArrayList<Pair<String, T>>(2);
        }
        pairs.add(Pair.create((Object)methodQualifiedName, computable));
        map.put(shortMethodName, pairs);
    }

    private static void addToMap(String methodQualifiedName, String typeBirthClassQualifiedName, Map<String, List<Pair<String, RSymbolBasedTypeComputable>>> map) {
        RubyDynamicExtensionsManager.addToMap(methodQualifiedName, RTypeUtil.createTypeByNameComputable(typeBirthClassQualifiedName), map);
    }

    public String dumpDynamicMethods() {
        return this.myDynamicMethods.dumpDynamicMethods();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberReturnTypeComputable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyDynamicExtensionsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerDynamicMethods";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addDynamicClassType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

