/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyExceptionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubySymbolsLookupCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;

public final class ExceptionCachingFilter {
    private ExceptionCachingFilter() {
    }

    public static boolean isAcceptedClass(@NotNull PsiElement element) {
        if (element == null) {
            ExceptionCachingFilter.$$$reportNull$$$0(0);
        }
        if (!(element instanceof RClass)) {
            return false;
        }
        RClass rClass = (RClass)element;
        FQN fqn = rClass.getFQNWithNesting();
        RubySymbolsLookupCache cache = RubySymbolsLookupCache.getInstance(element.getProject());
        Boolean isException = cache.isExceptionFQN(element, fqn);
        if (isException == null) {
            isException = RubyExceptionUtil.isExceptionClass(rClass);
            cache.registerExceptionFQN(element, fqn, isException);
        }
        if (!isException.booleanValue()) {
            return false;
        }
        VirtualFile virtualFile = rClass.getContainingFile().getVirtualFile();
        return virtualFile != null;
    }

    public static boolean isAcceptedConstant(@NotNull PsiElement element, @Nullable PsiElement invocationPoint) {
        if (element == null) {
            ExceptionCachingFilter.$$$reportNull$$$0(1);
        }
        if (!(element instanceof RConstantImpl)) {
            return false;
        }
        RConstantImpl rConstant = (RConstantImpl)element;
        FQN fqn = rConstant.getFQNWithNesting();
        RubySymbolsLookupCache cache = RubySymbolsLookupCache.getInstance(element.getProject());
        Boolean isException = cache.isExceptionFQN(element, fqn);
        if (isException == null) {
            isException = RubyExceptionUtil.isExceptionConstant(rConstant, invocationPoint);
            cache.registerExceptionFQN(element, fqn, isException);
        }
        if (!isException.booleanValue()) {
            return false;
        }
        VirtualFile virtualFile = rConstant.getContainingFile().getVirtualFile();
        return virtualFile != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/ExceptionCachingFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptedClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptedConstant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

