/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.providers.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.runAnything.activity.RunAnythingAnActionProvider;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.text.Matcher;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorAction;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.workspace.storage.ExtensionsKt;
import org.jetbrains.plugins.ruby.rails.workspace.storage.RailsGeneratorEntity;
import org.jetbrains.plugins.ruby.ruby.actions.providers.actions.RubyActionCompletionProvider;

public final class GeneratorActionProvider
extends RunAnythingAnActionProvider<SimpleGeneratorAction> {
    private static final String COMMAND_DELIMITER = ":";

    @Nullable
    public SimpleGeneratorAction findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            GeneratorActionProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            GeneratorActionProvider.$$$reportNull$$$0(1);
        }
        String input = pattern.substring(StringUtil.commonPrefixLength((CharSequence)pattern, (CharSequence)"rails generate")).trim();
        return (SimpleGeneratorAction)((Object)super.findMatchingValue(dataContext, "rails generate " + input));
    }

    @NotNull
    public Collection<SimpleGeneratorAction> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        Module module;
        if (dataContext == null) {
            GeneratorActionProvider.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            GeneratorActionProvider.$$$reportNull$$$0(3);
        }
        if ((module = RubyActionCompletionProvider.fetchModule(dataContext)) == null || !RailsFacetUtil.hasRailsSupport(module)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GeneratorActionProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        SortedList actions = new SortedList(GeneratorActionProvider.getCompletionComparator(pattern));
        for (RailsGeneratorEntity generator : SequencesKt.toList(ExtensionsKt.getRailsGenerators(module))) {
            AnAction anAction = ActionManager.getInstance().getAction(generator.getActionId());
            if (!(anAction instanceof SimpleGeneratorAction)) continue;
            SimpleGeneratorAction action = (SimpleGeneratorAction)anAction;
            actions.add(action);
        }
        List<SimpleGeneratorAction> list = Collections.unmodifiableList(actions);
        if (list == null) {
            GeneratorActionProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public String getCommand(@NotNull SimpleGeneratorAction value) {
        if (value == null) {
            GeneratorActionProvider.$$$reportNull$$$0(6);
        }
        String string = this.getHelpCommand() + " " + value.getGeneratorName();
        if (string == null) {
            GeneratorActionProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getCompletionGroupTitle() {
        String string = RBundle.message((String)"run.anything.rails.generators.group.title");
        if (string == null) {
            GeneratorActionProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getHelpCommandPlaceholder() {
        return "rails generate <name>";
    }

    @NotNull
    public String getHelpCommand() {
        return "rails generate";
    }

    public Icon getHelpIcon() {
        return AllIcons.FileTypes.Config;
    }

    @NotNull
    public String getHelpGroupTitle() {
        String string = RBundle.message((String)"run.anything.ruby.help.group.title");
        if (string == null) {
            GeneratorActionProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public Matcher getMatcher(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            GeneratorActionProvider.$$$reportNull$$$0(10);
        }
        if (pattern == null) {
            GeneratorActionProvider.$$$reportNull$$$0(11);
        }
        if (!pattern.startsWith("rails g")) {
            return null;
        }
        String input = pattern.substring(StringUtil.commonPrefixLength((CharSequence)pattern, (CharSequence)"rails generate")).trim();
        return ((NameUtil.MatcherBuilder)RunAnythingGroup.RUN_ANYTHING_MATCHER_BUILDER.fun((Object)input)).build();
    }

    @NotNull
    private static Comparator<SimpleGeneratorAction> getCompletionComparator(@NotNull String pattern) {
        if (pattern == null) {
            GeneratorActionProvider.$$$reportNull$$$0(12);
        }
        String input = pattern.startsWith("rails g") ? pattern.substring(StringUtil.commonPrefixLength((CharSequence)pattern, (CharSequence)"rails generate")).trim() : pattern;
        Comparator<SimpleGeneratorAction> comparator = Comparator.comparingInt(action -> {
            int index = ArrayUtil.indexOf((Object[])action.getGeneratorName().split(COMMAND_DELIMITER), (Object)input, String::startsWith);
            return index >= 0 ? index : Integer.MAX_VALUE;
        }).thenComparing(SimpleGeneratorAction::getGeneratorName);
        if (comparator == null) {
            GeneratorActionProvider.$$$reportNull$$$0(13);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/providers/actions/GeneratorActionProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/providers/actions/GeneratorActionProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpGroupTitle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMatcher";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionComparator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 9, 13 -> new IllegalStateException(string);
        };
    }
}

