/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.override;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.actions.RubyGotoSuperHandler;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RubyClassMember;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RubyClassMemberImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.OverriddenMethodGenerator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.VisibilityUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyOverrideHandler
implements LanguageCodeInsightActionHandler {
    private Function<? super List<? extends ClassMember>, ? extends List<ClassMember>> myChooser;

    @ApiStatus.Internal
    public void setMemberChooser(Function<? super List<? extends ClassMember>, ? extends List<ClassMember>> chooser) {
        this.myChooser = chooser;
    }

    public static @Unmodifiable @NotNull List<RubyClassMember> createOverrideMembers(@NotNull Symbol classSymbol, @NotNull PsiElement element) {
        if (classSymbol == null) {
            RubyOverrideHandler.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RubyOverrideHandler.$$$reportNull$$$0(1);
        }
        ArrayList result = new ArrayList();
        TypeSet overridableTypes = OverriddenMethodGenerator.getOverridableTypes();
        HashSet<String> seenNames = new HashSet<String>();
        for (Symbol methodSymbol2 : Symbol.getSymbolsByFilter((Symbol)classSymbol, (Predicate)Symbol.Filter.byTypes((TypeSet)overridableTypes), (PsiElement)element)) {
            seenNames.add(methodSymbol2.getName());
        }
        SymbolUtil.processMembers(classSymbol, (Predicate<? super Symbol>)Symbol.Filter.byTypes((TypeSet)overridableTypes), element, (Processor<? super Symbol>)((Processor)methodSymbol -> {
            PsiElement psiElement;
            String symbolName = methodSymbol.getName();
            if (seenNames.contains(symbolName)) {
                return true;
            }
            RubyClassMember member = OverriddenMethodGenerator.createMember(methodSymbol);
            if (member != null) {
                String name = member.getText();
                if (!(seenNames.contains(name) || "new".equals(name) || "initialize".equals(name))) {
                    seenNames.add(name);
                    result.add(member);
                }
            } else if (symbolName != null && (psiElement = methodSymbol.getPsiElement()) instanceof RMethod && symbolName.equals(((RMethod)psiElement).getName())) {
                result.add(new RubyClassMemberImpl((RPsiElement)psiElement));
            }
            seenNames.add(symbolName);
            return true;
        }));
        List list = ContainerUtil.filter(result, it -> !it.getText().isEmpty());
        if (list == null) {
            RubyOverrideHandler.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        return RubyGotoSuperHandler.findElementAndSymbol(editor, file, true) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        List selectedMembers;
        Pair<PsiElement, Symbol> elementAndSymbol;
        if (project == null) {
            RubyOverrideHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            RubyOverrideHandler.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            RubyOverrideHandler.$$$reportNull$$$0(5);
        }
        if ((elementAndSymbol = RubyGotoSuperHandler.findElementAndSymbol(editor, psiFile, true)) == null) {
            return;
        }
        List<RubyClassMember> overrideMembers = RubyOverrideHandler.createOverrideMembers((Symbol)elementAndSymbol.second, (PsiElement)elementAndSymbol.first);
        if (this.myChooser != null) {
            selectedMembers = this.myChooser.apply(overrideMembers);
        } else {
            MemberChooser chooser = new MemberChooser(overrideMembers.toArray(ClassMember.EMPTY_ARRAY), false, true, project);
            chooser.setTitle(RBundle.message((String)"refactoring.override.methods.title"));
            chooser.setCopyJavadocVisible(false);
            if (!chooser.showAndGet()) {
                return;
            }
            selectedMembers = chooser.getSelectedElements();
        }
        assert (selectedMembers != null);
        RubyOverrideHandler.generateAndInsert(project, editor, psiFile, editor.getCaretModel().getOffset(), selectedMembers);
    }

    public static void generateAndInsert(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int insertOffset, @NotNull List<? extends ClassMember> selectedMembers) {
        PsiElement whereToInsert;
        if (project == null) {
            RubyOverrideHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            RubyOverrideHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            RubyOverrideHandler.$$$reportNull$$$0(8);
        }
        if (selectedMembers == null) {
            RubyOverrideHandler.$$$reportNull$$$0(9);
        }
        if ((whereToInsert = file.findElementAt(insertOffset)) == null) {
            return;
        }
        Optional calculatedWhereToInsert = ((StreamEx)((StreamEx)((StreamEx)StreamEx.iterate((Object)whereToInsert, PsiTreeUtil::nextLeaf).takeWhile(Objects::nonNull)).filter(RubyOverrideHandler::isAllWhitespaces)).filter(it -> RubyPsiUtil.getParentSkippingAllCompoundPsiElements(it) instanceof RClass)).findFirst();
        if (calculatedWhereToInsert.isEmpty()) {
            return;
        }
        boolean calculatedOffsetDiffersFromProvided = calculatedWhereToInsert.get() != whereToInsert;
        int calculatedInsertOffset = calculatedOffsetDiffersFromProvided ? ((PsiElement)calculatedWhereToInsert.get()).getTextOffset() : insertOffset;
        Visibility currentPointVisibility = VisibilityUtil.getCurrentPointVisibility(file.findElementAt(calculatedInsertOffset));
        LanguageLevel languageLevel = RubyPsiUtilCore.getLanguageLevel((PsiElement)file);
        List newMethods = selectedMembers.stream().map(it -> RubyElementFactory.createMethodByElement(it, languageLevel, currentPointVisibility)).filter(Objects::nonNull).collect(Collectors.toList());
        if (newMethods.isEmpty()) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> RubyOverrideHandler.insertMethods(project, editor, file, calculatedInsertOffset, newMethods));
    }

    private static void insertMethods(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int insertOffset, @NotNull List<String> newMethods) {
        if (project == null) {
            RubyOverrideHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            RubyOverrideHandler.$$$reportNull$$$0(11);
        }
        if (file == null) {
            RubyOverrideHandler.$$$reportNull$$$0(12);
        }
        if (newMethods == null) {
            RubyOverrideHandler.$$$reportNull$$$0(13);
        }
        Object newMethodsJoined = String.join((CharSequence)"\n\n", newMethods);
        if (!RubyOverrideHandler.isAllWhitespaces(file.findElementAt(insertOffset - 1))) {
            newMethodsJoined = "\n\n" + (String)newMethodsJoined;
        }
        Document document = editor.getDocument();
        document.replaceString(insertOffset, insertOffset, (CharSequence)newMethodsJoined);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int methodDefinitionOffset = insertOffset + RubyOverrideHandler.numberOfLeadingWhitespaces((String)newMethodsJoined);
        if (newMethods.size() == 1) {
            Optional.ofNullable(RubyOverrideHandler.findRMethodInGeneratedDefinition(file.findElementAt(methodDefinitionOffset))).map(RubyOverrideHandler::findSuper).ifPresent(superKeyword -> {
                editor.getCaretModel().moveToOffset(superKeyword.getTextOffset());
                editor.getCaretModel().getCurrentCaret().setSelection(superKeyword.getTextOffset(), superKeyword.getTextRange().getEndOffset());
            });
        } else {
            editor.getCaretModel().moveToOffset(methodDefinitionOffset);
        }
        CodeStyleManager.getInstance((Project)project).reformatText(file, insertOffset, insertOffset + ((String)newMethodsJoined).length());
    }

    @Nullable
    private static RMethod findRMethodInGeneratedDefinition(@Nullable PsiElement element) {
        RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)element, RMethod.class);
        if (method != null) {
            return method;
        }
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)element, RCall.class);
        if (call == null) {
            return null;
        }
        String callCommand = call.getCommand();
        if (Arrays.stream(Visibility.values()).map(Visibility::getPresentableName).noneMatch(callCommand::equals)) {
            return null;
        }
        List args = call.getCallArguments().getElements();
        assert (args.size() == 1);
        RPsiElement arg = (RPsiElement)args.get(0);
        return arg instanceof RMethod ? (RMethod)arg : null;
    }

    private static boolean isAllWhitespaces(PsiElement it) {
        return it instanceof PsiWhiteSpace || it instanceof LeafPsiElement && it.getText().chars().allMatch(Character::isWhitespace);
    }

    private static int numberOfLeadingWhitespaces(@NotNull String str) {
        if (str == null) {
            RubyOverrideHandler.$$$reportNull$$$0(14);
        }
        return (int)IntStreamEx.of((IntStream)str.chars()).takeWhile(Character::isWhitespace).count();
    }

    @Nullable
    private static PsiElement findSuper(@NotNull RMethod method) {
        if (method == null) {
            RubyOverrideHandler.$$$reportNull$$$0(15);
        }
        return RubyPsiUtilCore.getChildByFilter((PsiElement)method.getCompoundStatement(), (IElementType)RubyElementTypes.PSEUDO_CONSTANT, (int)0);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSymbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/override/RubyOverrideHandler";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedMembers";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMethods";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/override/RubyOverrideHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverrideMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOverrideMembers";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateAndInsert";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertMethods";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "numberOfLeadingWhitespaces";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSuper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

