/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.refactorings;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RVariable;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.variable.RubyIntroduceVariableHandler;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementElement;

public final class RubyIntroduceLocalVariableIntention
extends BaseElementAtCaretIntentionAction
implements HighPriorityAction {
    private static final Set<Class<?>> IGNORED_EXPRESSION_CLASSES = Set.of(RIdentifier.class, RModifierStatement.class, RPseudoConstant.class, RReturnStatement.class, RVariable.class);

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.introduce.local.variable");
        if (string == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsContexts.ListItem
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.introduce.local.variable");
        if (string == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(4);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(5);
        }
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(8);
        }
        RExpression expression = RubyIntroduceLocalVariableIntention.getExpressionAtCaret(element);
        assert (expression != null);
        if (!FileModificationService.getInstance().prepareFileForWrite(expression.getContainingFile())) {
            return;
        }
        RubyReplacementElement replacement = new RubyReplacementElement(element, (RPsiElement)expression, (RPsiElement)ScopeUtilCore.findScopeHolder((PsiElement)expression));
        new RubyIntroduceVariableHandler().performActionOnElement(project, editor, replacement, null, true);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Document document;
        if (project == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(10);
        }
        if (element == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(11);
        }
        if (TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element) || editor.getSelectionModel().hasSelection()) {
            return false;
        }
        RExpression expression = RubyIntroduceLocalVariableIntention.getExpressionAtCaret(element);
        if (expression == null || ContainerUtil.exists(IGNORED_EXPRESSION_CLASSES, clazz -> clazz.isInstance(expression))) {
            return false;
        }
        if (expression instanceof RBlockStatement && (document = editor.getDocument()).getLineNumber(expression.getTextOffset()) != document.getLineNumber(element.getTextOffset())) {
            return false;
        }
        if (expression instanceof RBlockCall && PsiTreeUtil.isAncestor((PsiElement)((RBlockCall)expression).getBlock(), (PsiElement)element, (boolean)false)) {
            return false;
        }
        if (RubyPsiUtilCore.hasNonEditableFragment((Project)project, (Document)editor.getDocument(), (PsiElement)expression)) {
            return false;
        }
        return RefactoringPsiHelper.checkCanExtract((RPsiElement)expression, true, "refactoring.introduceVariable") == null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static RExpression getExpressionAtCaret(@NotNull PsiElement element) {
        RListOfExpressions listOfExpressions;
        RReturnStatement returnStatement;
        if (element == null) {
            RubyIntroduceLocalVariableIntention.$$$reportNull$$$0(12);
        }
        if ((returnStatement = (RReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RReturnStatement.class)) != null && (listOfExpressions = returnStatement.getReturnList()) != null && PsiTreeUtil.isAncestor((PsiElement)listOfExpressions, (PsiElement)element, (boolean)false)) {
            return (RExpression)ObjectUtils.tryCast((Object)PsiTreeUtil.findPrevParent((PsiElement)listOfExpressions, (PsiElement)element), RExpression.class);
        }
        RCompoundStatement compoundStatement = (RCompoundStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RCompoundStatement.class);
        if (compoundStatement != null) {
            return (RExpression)ObjectUtils.tryCast((Object)PsiTreeUtil.findPrevParent((PsiElement)compoundStatement, (PsiElement)element), RExpression.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/refactorings/RubyIntroduceLocalVariableIntention";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/refactorings/RubyIntroduceLocalVariableIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAtCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

