/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.operators;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RubyParenthesesExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;

public final class RubyRemoveUnnecessaryParenthesesIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    private static final TokenSet PARENTHESES = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tLPARENS, TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tRPAREN})});

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.remove.parentheses");
        if (string == null) {
            RubyRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.remove.parentheses");
        if (string == null) {
            RubyRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(4);
        }
        RGroupedExpression groupedExpression = (RGroupedExpression)ObjectUtils.tryCast((Object)element.getParent(), RGroupedExpression.class);
        assert (groupedExpression != null);
        PsiElement leftParenthesis = groupedExpression.getFirstChild();
        PsiElement rightParenthesis = groupedExpression.getLastChild();
        Document document = editor.getDocument();
        document.deleteString(rightParenthesis.getTextOffset(), rightParenthesis.getTextRange().getEndOffset());
        document.deleteString(leftParenthesis.getTextOffset(), leftParenthesis.getTextRange().getEndOffset());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        int expressionPriority;
        if (project == null) {
            RubyRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(7);
        }
        if (!PARENTHESES.contains(PsiUtilCore.getElementType((PsiElement)element))) {
            return false;
        }
        RGroupedExpression groupedExpression = (RGroupedExpression)ObjectUtils.tryCast((Object)element.getParent(), RGroupedExpression.class);
        if (groupedExpression == null) {
            return false;
        }
        PsiElement parent = groupedExpression.getParent();
        PsiElement expression = RubyParenthesesExpressionUtil.getExpression((PsiElement)groupedExpression, 2);
        if (!(parent instanceof RPsiElement) || !(expression instanceof RPsiElement)) {
            return false;
        }
        int parentPriority = RubyReplaceExpressionUtil.getExpressionPriority((RPsiElement)parent);
        if (parentPriority > (expressionPriority = RubyReplaceExpressionUtil.getExpressionPriority((RPsiElement)expression))) {
            return false;
        }
        if (parent instanceof RBinaryExpression) {
            RBinaryExpression binaryExpression = (RBinaryExpression)parent;
            if (parentPriority == expressionPriority && parentPriority != 10) {
                return !RubyReplaceExpressionUtil.isNotAssociative(binaryExpression) || !groupedExpression.equals((Object)binaryExpression.getRightOperand());
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/RubyRemoveUnnecessaryParenthesesIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/RubyRemoveUnnecessaryParenthesesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

