/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.operators;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;

public final class RubyAddClarifyingParenthesesIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.add.clarifying.parentheses");
        if (string == null) {
            RubyAddClarifyingParenthesesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.add.clarifying.parentheses");
        if (string == null) {
            RubyAddClarifyingParenthesesIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyAddClarifyingParenthesesIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyAddClarifyingParenthesesIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyAddClarifyingParenthesesIntention.$$$reportNull$$$0(4);
        }
        PsiElement parent = RubyAddClarifyingParenthesesIntention.findUnclearExpression(element);
        assert (parent != null);
        parent.accept((PsiElementVisitor)new MyUnclearExpressionVisitor(MyUnclearExpressionVisitor.Mode.MODIFY));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RubyAddClarifyingParenthesesIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyAddClarifyingParenthesesIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyAddClarifyingParenthesesIntention.$$$reportNull$$$0(7);
        }
        return RubyAddClarifyingParenthesesIntention.findUnclearExpression(element) != null;
    }

    @Nullable
    private static PsiElement findUnclearExpression(@NotNull PsiElement element) {
        PsiElement parent2;
        PsiElement candidate;
        if (element == null) {
            RubyAddClarifyingParenthesesIntention.$$$reportNull$$$0(8);
        }
        for (candidate = PsiTreeUtil.findFirstParent((PsiElement)element, parent -> {
            MyUnclearExpressionVisitor visitor = new MyUnclearExpressionVisitor(MyUnclearExpressionVisitor.Mode.SEARCH);
            parent.accept((PsiElementVisitor)visitor);
            return visitor.hasUnclearExpression();
        }); candidate != null && ((parent2 = candidate.getParent()) instanceof RBinaryExpression || parent2 instanceof RTernaryExpression); candidate = candidate.getParent()) {
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/RubyAddClarifyingParenthesesIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/RubyAddClarifyingParenthesesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findUnclearExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyUnclearExpressionVisitor
    extends RubyElementVisitor {
        private static final List<IElementType> IGNORED_OPERATION_TYPES = List.of(RubyTokenTypes.tCMP, RubyTokenTypesCore.tEQ, RubyTokenTypes.tEQQ, RubyTokenTypes.tNEQ, RubyTokenTypes.tMATCH, RubyTokenTypes.tNMATCH, RubyTokenTypes.tLT, RubyTokenTypes.tLEQ, RubyTokenTypes.tGT, RubyTokenTypes.tGEQ);
        private final Mode myMode;
        private boolean myHasUnclearExpression;

        private MyUnclearExpressionVisitor(@NotNull Mode mode) {
            if (mode == null) {
                MyUnclearExpressionVisitor.$$$reportNull$$$0(0);
            }
            this.myHasUnclearExpression = false;
            this.myMode = mode;
        }

        public void visitRBinaryExpression(@NotNull RBinaryExpression binaryExpression) {
            RPsiElement rightOperand;
            RPsiElement leftOperand;
            if (binaryExpression == null) {
                MyUnclearExpressionVisitor.$$$reportNull$$$0(1);
            }
            if ((leftOperand = binaryExpression.getLeftOperand()) != null) {
                this.processElement((PsiElement)leftOperand, (PsiElement)binaryExpression);
            }
            if ((rightOperand = binaryExpression.getRightOperand()) != null) {
                this.processElement((PsiElement)rightOperand, (PsiElement)binaryExpression);
            }
        }

        public void visitRTernaryExpression(@NotNull RTernaryExpression ternaryExpression) {
            RPsiElement falseCommand;
            RPsiElement trueCommand;
            RCondition condition;
            if (ternaryExpression == null) {
                MyUnclearExpressionVisitor.$$$reportNull$$$0(2);
            }
            if ((condition = ternaryExpression.getCondition()) != null) {
                this.processElement(condition.getFirstChild(), (PsiElement)ternaryExpression);
            }
            if ((trueCommand = ternaryExpression.getTrueCommand()) != null) {
                this.processElement((PsiElement)trueCommand, (PsiElement)ternaryExpression);
            }
            if ((falseCommand = ternaryExpression.getFalseCommand()) != null) {
                this.processElement((PsiElement)falseCommand, (PsiElement)ternaryExpression);
            }
        }

        private boolean hasUnclearExpression() {
            return this.myHasUnclearExpression;
        }

        private void processElement(@NotNull PsiElement child, @NotNull PsiElement parent) {
            if (child == null) {
                MyUnclearExpressionVisitor.$$$reportNull$$$0(3);
            }
            if (parent == null) {
                MyUnclearExpressionVisitor.$$$reportNull$$$0(4);
            }
            child.accept((PsiElementVisitor)this);
            if (MyUnclearExpressionVisitor.needsClarifyingParentheses(child, parent)) {
                this.myHasUnclearExpression = true;
                if (this.myMode == Mode.MODIFY) {
                    child.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)parent, (String)("(" + child.getText() + ")")));
                }
            }
        }

        private static boolean needsClarifyingParentheses(@NotNull PsiElement child, @NotNull PsiElement parent) {
            if (child == null) {
                MyUnclearExpressionVisitor.$$$reportNull$$$0(5);
            }
            if (parent == null) {
                MyUnclearExpressionVisitor.$$$reportNull$$$0(6);
            }
            if (child instanceof RTernaryExpression) {
                return true;
            }
            if (parent instanceof RTernaryExpression) {
                return child instanceof RBinaryExpression;
            }
            IElementType childOperationType = (IElementType)ObjectUtils.doIfCast((Object)child, RBinaryExpression.class, RBinaryExpression::getOperationType);
            IElementType parentOperationType = (IElementType)ObjectUtils.doIfCast((Object)parent, RBinaryExpression.class, RBinaryExpression::getOperationType);
            if (childOperationType == null || parentOperationType == null || IGNORED_OPERATION_TYPES.contains(parentOperationType)) {
                return false;
            }
            return RubyReplaceExpressionUtil.getBinaryTypePriority(childOperationType) != RubyReplaceExpressionUtil.getBinaryTypePriority(parentOperationType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ternaryExpression";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/RubyAddClarifyingParenthesesIntention$MyUnclearExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRBinaryExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRTernaryExpression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "needsClarifyingParentheses";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum Mode {
            SEARCH,
            MODIFY;

        }
    }
}

