/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.operators;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.actions.intention.RubyMutablyNamedIntention;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RBoolBinExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;

public final class DemorgansIntention
extends RubyMutablyNamedIntention<RBoolBinExpression>
implements DumbAware {
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.demorgans");
        if (string == null) {
            DemorgansIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        RBoolBinExpression expression;
        if (project == null) {
            DemorgansIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            DemorgansIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            DemorgansIntention.$$$reportNull$$$0(3);
        }
        if ((expression = this.findMatchingElement(project, editor, element)) == null) {
            return;
        }
        String convertedExpressionText = DemorgansIntention.convertBoolBinExpression(expression);
        if (convertedExpressionText.isEmpty()) {
            return;
        }
        PsiElement elementToReplace = DemorgansIntention.getParenthesizedAncestor((PsiElement)expression);
        PsiElement parent = elementToReplace.getParent();
        RPsiElement convertedExpression = RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)convertedExpressionText);
        if (elementToReplace instanceof RBoolNegExpression) {
            if (!(!(parent instanceof RBoolBinExpression) || convertedExpression instanceof RGroupedExpression && RubyPsiUtil.isInParentheses(convertedExpression) || convertedExpression instanceof RBoolNegExpression)) {
                DemorgansIntention.checkForBrokenPriorityAndReplace(element.getContainingFile(), elementToReplace, (RBoolBinExpression)parent, expression, convertedExpressionText);
            } else {
                elementToReplace.replace((PsiElement)convertedExpression);
            }
        } else if (DemorgansIntention.isConditionToReplace(parent)) {
            DemorgansIntention.replaceConditional(element.getContainingFile(), (RConditionalStatement)parent.getParent(), convertedExpressionText);
        } else {
            elementToReplace.replace((PsiElement)RubyRefactoringUtil.negateExpression((PsiElement)convertedExpression));
        }
        if (parent instanceof RBoolBinExpression) {
            DemorgansIntention.restorePsiTree((RBoolBinExpression)parent);
        }
    }

    @Override
    @Nullable
    protected String getTextForElement(@NotNull RBoolBinExpression element) {
        IElementType operation;
        IElementType switchedOperation;
        if (element == null) {
            DemorgansIntention.$$$reportNull$$$0(4);
        }
        if ((switchedOperation = RBoolBinExpressionImpl.getSwitchedOperation((IElementType)(operation = element.getOperationType()))) == null) {
            return null;
        }
        PsiElement elementToReplace = DemorgansIntention.getParenthesizedAncestor((PsiElement)element);
        PsiElement parent = elementToReplace.getParent();
        if (parent.getParent() instanceof RBlockStatement && ((RBlockStatement)parent.getParent()).getEndToken() == null) {
            return null;
        }
        return RBundle.message((String)"ruby.intentions.replace.with", (Object[])new Object[]{operation.toString(), switchedOperation.toString()});
    }

    @Override
    @Nullable
    protected RBoolBinExpression findMatchingElement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        RBoolBinExpression boolBinExpression;
        if (project == null) {
            DemorgansIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            DemorgansIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            DemorgansIntention.$$$reportNull$$$0(7);
        }
        if ((boolBinExpression = (RBoolBinExpression)PsiTreeUtil.getParentOfType((PsiElement)element, RBoolBinExpression.class)) != null && boolBinExpression.getRightOperand() != null && RBoolBinExpressionImpl.getSwitchedOperation((IElementType)boolBinExpression.getOperationType()) != null) {
            IElementType operation = boolBinExpression.getOperationType();
            while (boolBinExpression.getParent() instanceof RBoolBinExpression && operation == ((RBoolBinExpression)boolBinExpression.getParent()).getOperationType()) {
                boolBinExpression = (RBoolBinExpression)boolBinExpression.getParent();
            }
            return boolBinExpression;
        }
        return null;
    }

    private static void restorePsiTree(@NotNull RBoolBinExpression element) {
        if (element == null) {
            DemorgansIntention.$$$reportNull$$$0(8);
        }
        if (element.getParent() instanceof RBoolBinExpression && element.getOperationType() == ((RBoolBinExpression)element.getParent()).getOperationType() && ((RBoolBinExpression)element.getParent()).getRightOperand() == element) {
            element = (RBoolBinExpression)element.getParent();
        }
        element.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)element.getText()));
    }

    private static void checkForBrokenPriorityAndReplace(@NotNull PsiFile file, @NotNull PsiElement elementToReplace, @NotNull RBoolBinExpression parentExpression, @NotNull RBoolBinExpression element, @NotNull String convertedExpression) {
        if (file == null) {
            DemorgansIntention.$$$reportNull$$$0(9);
        }
        if (elementToReplace == null) {
            DemorgansIntention.$$$reportNull$$$0(10);
        }
        if (parentExpression == null) {
            DemorgansIntention.$$$reportNull$$$0(11);
        }
        if (element == null) {
            DemorgansIntention.$$$reportNull$$$0(12);
        }
        if (convertedExpression == null) {
            DemorgansIntention.$$$reportNull$$$0(13);
        }
        IElementType parentType = parentExpression.getOperationType();
        IElementType type = RBoolBinExpressionImpl.getSwitchedOperation((IElementType)element.getOperationType());
        if (type == null) {
            elementToReplace.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)convertedExpression));
            return;
        }
        int priority = RubyReplaceExpressionUtil.getBinaryTypePriority(type);
        int parentPriority = RubyReplaceExpressionUtil.getBinaryTypePriority(parentType);
        if (parentPriority > priority || parentType != type && parentPriority == priority && PsiTreeUtil.isAncestor((PsiElement)parentExpression.getRightOperand(), (PsiElement)element, (boolean)false)) {
            elementToReplace.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)("(" + convertedExpression + ")")));
        } else {
            elementToReplace.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)convertedExpression));
        }
    }

    @NotNull
    private static String convertBoolBinExpression(@NotNull RBoolBinExpression boolBinExpression) {
        IElementType operationType;
        if (boolBinExpression == null) {
            DemorgansIntention.$$$reportNull$$$0(14);
        }
        if ((operationType = RBoolBinExpressionImpl.getSwitchedOperation((IElementType)boolBinExpression.getOperationType())) == null) {
            return "";
        }
        String operation = operationType.toString();
        StringBuilder result = new StringBuilder();
        RBoolBinExpression child = boolBinExpression;
        while (child instanceof RBoolBinExpression && child.getOperationType() == boolBinExpression.getOperationType()) {
            RPsiElement rightOperand = child.getRightOperand();
            if (rightOperand != null) {
                if (rightOperand instanceof RBoolNegExpression && ((RBoolNegExpression)rightOperand).getElement() instanceof RGroupedExpression) {
                    result.insert(0, "(" + RubyRefactoringUtil.negateExpression((PsiElement)rightOperand).getText() + ")");
                } else {
                    result.insert(0, RubyRefactoringUtil.negateExpression((PsiElement)rightOperand).getText());
                }
            } else {
                return "";
            }
            result.insert(0, " " + operation + " ");
            child = child.getLeftOperand();
        }
        if (child instanceof RBoolNegExpression && ((RBoolNegExpression)child).getElement() instanceof RGroupedExpression) {
            result.insert(0, "(" + RubyRefactoringUtil.negateExpression((PsiElement)child).getText() + ")");
        } else {
            result.insert(0, RubyRefactoringUtil.negateExpression((PsiElement)child).getText());
        }
        String string = result.toString();
        if (string == null) {
            DemorgansIntention.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static void replaceConditional(@NotNull PsiFile file, @NotNull RConditionalStatement conditional, @NotNull String negatedExpression) {
        Object replacement;
        IElementType replacedKeyword;
        if (file == null) {
            DemorgansIntention.$$$reportNull$$$0(16);
        }
        if (conditional == null) {
            DemorgansIntention.$$$reportNull$$$0(17);
        }
        if (negatedExpression == null) {
            DemorgansIntention.$$$reportNull$$$0(18);
        }
        if ((replacedKeyword = RubyPsiUtil.getNegativeKeyword(conditional)) == null) {
            return;
        }
        if (conditional instanceof RBlockStatement) {
            RBlockStatement statement = (RBlockStatement)conditional;
            if (statement.getEndToken() == null) {
                return;
            }
            replacement = DemorgansIntention.getBlockReplacement(conditional, negatedExpression, replacedKeyword);
        } else if (conditional instanceof RModifierStatement) {
            RModifierStatement statement = (RModifierStatement)conditional;
            replacement = statement.getCommand().getText() + " " + replacedKeyword.toString() + " " + negatedExpression;
        } else {
            return;
        }
        conditional.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)replacement));
    }

    @NotNull
    private static String getBlockReplacement(@NotNull RConditionalStatement conditional, @NotNull String negatedExpression, @NotNull IElementType replacedKeyword) {
        RIfStatement statement;
        if (conditional == null) {
            DemorgansIntention.$$$reportNull$$$0(19);
        }
        if (negatedExpression == null) {
            DemorgansIntention.$$$reportNull$$$0(20);
        }
        if (replacedKeyword == null) {
            DemorgansIntention.$$$reportNull$$$0(21);
        }
        if (!(conditional instanceof RIfStatement) || (statement = (RIfStatement)conditional).getElseBlock() == null) {
            int offset = conditional.getCondition().getTextRange().getStartOffset() + conditional.getCondition().getTextLength() - conditional.getTextRange().getStartOffset();
            String body = conditional.getText().substring(offset);
            String string = replacedKeyword.toString() + " " + negatedExpression + body;
            if (string == null) {
                DemorgansIntention.$$$reportNull$$$0(22);
            }
            return string;
        }
        RCompoundStatement thenStatement = statement.getThenBlock();
        RCompoundStatement elseStatement = statement.getElseBlock().getBody();
        int statementOffset = statement.getTextRange().getStartOffset();
        int elseEnd = elseStatement.getTextRange().getEndOffset() - statementOffset;
        String betweenThenElse = DemorgansIntention.getTextBetween((PsiElement)statement, (PsiElement)thenStatement, (PsiElement)elseStatement);
        String betweenConditionThen = DemorgansIntention.getTextBetween((PsiElement)statement, (PsiElement)statement.getCondition(), (PsiElement)thenStatement);
        String string = RubyTokenTypes.kIF.toString() + " " + negatedExpression + betweenConditionThen + elseStatement.getText() + betweenThenElse + thenStatement.getText() + statement.getText().substring(elseEnd);
        if (string == null) {
            DemorgansIntention.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String getTextBetween(@NotNull PsiElement parent, @NotNull PsiElement start, @NotNull PsiElement end) {
        if (parent == null) {
            DemorgansIntention.$$$reportNull$$$0(24);
        }
        if (start == null) {
            DemorgansIntention.$$$reportNull$$$0(25);
        }
        if (end == null) {
            DemorgansIntention.$$$reportNull$$$0(26);
        }
        int parentOffset = parent.getTextRange().getStartOffset();
        int startOffset = start.getTextRange().getEndOffset() - parentOffset;
        int endOffset = end.getTextRange().getStartOffset() - parentOffset;
        String string = parent.getText().substring(startOffset, endOffset);
        if (string == null) {
            DemorgansIntention.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static PsiElement getParenthesizedAncestor(@NotNull PsiElement element) {
        if (element == null) {
            DemorgansIntention.$$$reportNull$$$0(28);
        }
        while (element.getParent() instanceof RCompoundStatement && element.getParent().getParent() instanceof RGroupedExpression && RubyPsiUtil.isInParentheses((RPsiElement)element.getParent().getParent()) && ((RCompoundStatement)element.getParent()).getStatements().size() == 1) {
            element = element.getParent().getParent();
        }
        PsiElement psiElement = element.getParent() instanceof RBoolNegExpression ? element.getParent() : element;
        if (psiElement == null) {
            DemorgansIntention.$$$reportNull$$$0(29);
        }
        return psiElement;
    }

    private static boolean isConditionToReplace(@NotNull PsiElement candidate) {
        if (candidate == null) {
            DemorgansIntention.$$$reportNull$$$0(30);
        }
        return candidate instanceof RCondition && candidate.getParent() instanceof RConditionalStatement && (!(candidate.getParent() instanceof RIfStatement) || ((RIfStatement)candidate.getParent()).getElsifBlocks().isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 24, 25, 26, 28, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/DemorgansIntention";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReplace";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertedExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boolBinExpression";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditional";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negatedExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacedKeyword";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/DemorgansIntention";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertBoolBinExpression";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockReplacement";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextBetween";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getParenthesizedAncestor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextForElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restorePsiTree";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkForBrokenPriorityAndReplace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertBoolBinExpression";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceConditional";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBlockReplacement";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTextBetween";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParenthesizedAncestor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isConditionToReplace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 24, 25, 26, 28, 30 -> new IllegalArgumentException(string);
        };
    }
}

