/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.numbers;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RNumericConstant;

public final class RubyAddUnderscoresToNumberIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.add.underscores");
        if (string == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.add.underscores");
        if (string == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(4);
        }
        RNumericConstant literal = (RNumericConstant)PsiTreeUtil.getParentOfType((PsiElement)element, RNumericConstant.class);
        assert (literal != null);
        literal.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)RubyAddUnderscoresToNumberIntention.format(literal.getText())));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        RNumericConstant literal;
        if (project == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(7);
        }
        if ((literal = (RNumericConstant)PsiTreeUtil.getParentOfType((PsiElement)element, RNumericConstant.class)) == null) {
            return false;
        }
        String text = literal.getText();
        if (StringUtil.containsAnyChar((String)text, (String)"_eE")) {
            return false;
        }
        return !text.equals(RubyAddUnderscoresToNumberIntention.format(text));
    }

    @NotNull
    private static String format(@NotNull String value) {
        if (value == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(8);
        }
        String text = value;
        String sign = StringUtil.notNullize((String)((String)ContainerUtil.find(Holder.SUPPORTED_SIGNS, text::startsWith)));
        text = text.substring(sign.length());
        String prefix = StringUtil.notNullize((String)((String)ContainerUtil.find(Holder.SUPPORTED_PREFIXES, text::startsWith)));
        text = text.substring(prefix.length());
        int groupSize = StringUtil.containsAnyChar((String)prefix, (String)"bBxX") ? 4 : 3;
        StringBuilder sb = new StringBuilder(sign + prefix);
        String integer = (String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)text, (String)"."), (Object)text);
        for (int i = 0; i < integer.length(); ++i) {
            if (i != 0 && (integer.length() - i) % groupSize == 0) {
                sb.append("_");
            }
            sb.append(integer.charAt(i));
        }
        String decimal = StringUtil.substringAfter((String)value, (String)".");
        if (decimal != null) {
            sb.append('.');
            for (int i = 0; i < decimal.length(); ++i) {
                if (i != 0 && i % groupSize == 0) {
                    sb.append("_");
                }
                sb.append(decimal.charAt(i));
            }
        }
        String string = sb.toString();
        if (string == null) {
            RubyAddUnderscoresToNumberIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/numbers/RubyAddUnderscoresToNumberIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/numbers/RubyAddUnderscoresToNumberIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private static class Holder {
        private static final String UNSUPPORTED_FORMATS = "_eE";
        private static final List<String> SUPPORTED_SIGNS = List.of("+", "-");
        private static final List<String> SUPPORTED_PREFIXES = List.of("0b", "0B", "0o", "0O", "0x", "0X", "0");

        private Holder() {
        }
    }
}

