/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.hashes;

import com.google.common.collect.Comparators;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RFloatConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RRangeExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.assoc.RAssocListNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;

public final class RubySortHashByKeysIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    private static final ToIntFunction<PsiElement> CLASS_RANKER = element -> {
        if (element instanceof RStringLiteral) {
            return 0;
        }
        if (element instanceof RAssocKey || element instanceof RSymbol) {
            return 1;
        }
        if (element instanceof RColonReference || element instanceof RConstant || element instanceof RTopConstReference) {
            return 2;
        }
        if (element instanceof RRangeExpression) {
            return 3;
        }
        if (element instanceof RIntegerConstant) {
            return 4;
        }
        if (element instanceof RFloatConstant) {
            return 5;
        }
        if (element instanceof RPseudoConstant) {
            return 6;
        }
        return Integer.MAX_VALUE;
    };
    private static final Comparator<RRangeExpression> RANGE_COMPARATOR = RubySortHashByKeysIntention.createRangeComparator();
    private static final Comparator<RIntegerConstant> INTEGER_COMPARATOR = Comparator.comparing(RIntegerConstant::getValue, Comparator.nullsLast(Comparator.naturalOrder()));
    private static final Comparator<RFloatConstant> FLOAT_COMPARATOR = Comparator.comparing(RFloatConstant::getValue, Comparator.nullsLast(Comparator.naturalOrder()));
    private static final Comparator<PsiElement> TEXT_COMPARATOR = Comparator.comparing(element -> (String)ObjectUtils.coalesce((Object)RubyPsiUtilCore.getElementText((PsiElement)element), (Object)element.getText()));
    private static final Comparator<PsiElement> VALUE_COMPARATOR = (first, second) -> {
        if (first instanceof RRangeExpression && second instanceof RRangeExpression) {
            return RANGE_COMPARATOR.compare((RRangeExpression)first, (RRangeExpression)second);
        }
        if (first instanceof RIntegerConstant && second instanceof RIntegerConstant) {
            return INTEGER_COMPARATOR.compare((RIntegerConstant)first, (RIntegerConstant)second);
        }
        if (first instanceof RFloatConstant && second instanceof RFloatConstant) {
            return FLOAT_COMPARATOR.compare((RFloatConstant)first, (RFloatConstant)second);
        }
        return TEXT_COMPARATOR.compare((PsiElement)first, (PsiElement)second);
    };
    private static final Comparator<RAssoc> ASSOC_COMPARATOR = Comparator.comparing(RAssoc::getKey, Comparator.comparingInt(CLASS_RANKER).thenComparing(VALUE_COMPARATOR));

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.sort.hash.by.keys");
        if (string == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.sort.hash.by.keys");
        if (string == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(4);
        }
        RAssocList assocList = RubySortHashByKeysIntention.getParentAssocList(element);
        assert (assocList != null);
        assocList.replace((PsiElement)RubySortHashByKeysIntention.createSortedAssocList(assocList));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        RAssocList assocList;
        if (project == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(7);
        }
        if ((assocList = RubySortHashByKeysIntention.getParentAssocList(element)) == null || !assocList.isSimple()) {
            return false;
        }
        if (Comparators.isInOrder((Iterable)assocList.getAssocElements(), ASSOC_COMPARATOR)) {
            return false;
        }
        return !ContainerUtil.or((Iterable)assocList.getAssocElements(), assoc -> assoc.getKey() == null || assoc.getValue() == null || !RubySortHashByKeysIntention.isSortable(assoc));
    }

    @NotNull
    private static Comparator<RRangeExpression> createRangeComparator() {
        Comparator<RRangeExpression> comparator = Comparator.comparing(range -> (PsiElement)ObjectUtils.coalesce((Object)range.getLeftOperand(), (Object)range.getRightOperand()), Comparator.comparingInt(CLASS_RANKER)).thenComparing(RBinaryExpression::getLeftOperand, (first, second) -> Comparator.nullsFirst(VALUE_COMPARATOR).compare((PsiElement)first, (PsiElement)second));
        if (comparator == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(8);
        }
        return comparator;
    }

    @NotNull
    private static RAssocList createSortedAssocList(@NotNull RAssocList assocList) {
        PsiElement comma;
        if (assocList == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(9);
        }
        LinkedHashMap<RAssoc, TextRange> assocTextRangeMap = new LinkedHashMap<RAssoc, TextRange>();
        int startOffset = 1;
        for (RAssoc assoc : assocList.getAssocElements()) {
            Object anchor = (PsiElement)ObjectUtils.coalesce((Object)PsiTreeUtil.findSiblingForward((PsiElement)assoc, (IElementType)RubyTokenTypes.tCOMMA, (boolean)true, null), (Object)assoc);
            anchor = (PsiElement)ObjectUtils.coalesce((Object)RubyCommentsUtil.getEndOfLineComment((PsiElement)anchor), (Object)anchor);
            int endOffset = anchor.getTextRangeInParent().getEndOffset();
            assocTextRangeMap.put(assoc, TextRange.create((int)startOffset, (int)endOffset));
            startOffset = endOffset;
        }
        String originalAssocListText = assocList.getText();
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry entry : ContainerUtil.sorted(assocTextRangeMap.entrySet(), Map.Entry.comparingByKey(ASSOC_COMPARATOR))) {
            RAssoc assoc = (RAssoc)entry.getKey();
            TextRange textRange = (TextRange)entry.getValue();
            int commaOffset = assoc.getTextRangeInParent().getEndOffset();
            sb.append(TextRange.create((int)textRange.getStartOffset(), (int)commaOffset).substring(originalAssocListText));
            if (PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)assoc)) != RubyTokenTypes.tCOMMA) {
                sb.append(",");
            }
            sb.append(TextRange.create((int)commaOffset, (int)textRange.getEndOffset()).substring(originalAssocListText));
        }
        sb.append(originalAssocListText.substring(startOffset));
        RAssocList newAssocList = (RAssocList)RubyElementFactoryCore.createElementFromText((PsiElement)assocList, (String)sb.toString());
        if (PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)assocList.getLastChild())) != RubyTokenTypes.tCOMMA && (comma = PsiTreeUtil.findSiblingBackward((PsiElement)newAssocList.getLastChild(), (IElementType)RubyTokenTypes.tCOMMA, null)) != null) {
            comma.delete();
        }
        RAssocList rAssocList = newAssocList;
        if (rAssocList == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(10);
        }
        return rAssocList;
    }

    private static boolean isSortable(@NotNull RAssoc assoc) {
        if (assoc == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(11);
        }
        return !ContainerUtil.or(Holder.EXCLUDED_CLASSES, clazz -> clazz.isInstance(assoc.getKey()));
    }

    @Nullable
    private static RAssocList getParentAssocList(@NotNull PsiElement element) {
        RAssoc assoc;
        if (element == null) {
            RubySortHashByKeysIntention.$$$reportNull$$$0(12);
        }
        if ((assoc = (RAssoc)PsiTreeUtil.getParentOfType((PsiElement)element, RAssoc.class)) != null && PsiTreeUtil.isAncestor((PsiElement)assoc.getKey(), (PsiElement)element, (boolean)false)) {
            return RAssocListNavigator.getByAssoc((RAssoc)assoc);
        }
        return (RAssocList)ObjectUtils.tryCast((Object)element.getParent(), RAssocList.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 9, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/hashes/RubySortHashByKeysIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assoc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/hashes/RubySortHashByKeysIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeComparator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSortedAssocList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSortedAssocList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSortable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParentAssocList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 9, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    private static class Holder {
        private static final List<Class<?>> EXCLUDED_CLASSES = List.of(RIdentifier.class);

        private Holder() {
        }
    }
}

