/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.declarations;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.modules.RModuleNavigator;

public final class RubyFlattenNamespaceIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.flatten.namespace");
        if (string == null) {
            RubyFlattenNamespaceIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.flatten.namespace.changes.semantics");
        if (string == null) {
            RubyFlattenNamespaceIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyFlattenNamespaceIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyFlattenNamespaceIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyFlattenNamespaceIntention.$$$reportNull$$$0(4);
        }
        RName name = (RName)PsiTreeUtil.getParentOfType((PsiElement)element, RName.class);
        assert (name != null);
        RContainer container = (RContainer)ObjectUtils.coalesce((Object)RClassNavigator.getByName((RName)name), (Object)RModuleNavigator.getByName((RName)name));
        assert (container != null);
        name.getFirstChild().replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)container.getFQNWithNesting().getFullPath()));
        RModule topmostModule = (RModule)PsiTreeUtil.getTopmostParentOfType((PsiElement)container, RModule.class);
        assert (topmostModule != null);
        List comments = RubyCommentsUtilCore.getPsiComments((PsiElement)container);
        if (!comments.isEmpty()) {
            PsiComment firstComment = (PsiComment)ContainerUtil.getFirstItem((List)comments);
            assert (firstComment != null);
            topmostModule.getParent().addRangeBefore((PsiElement)firstComment, (PsiElement)ContainerUtil.getLastItem((List)comments), (PsiElement)topmostModule);
        }
        RContainer newContainer = (RContainer)container.copy();
        topmostModule.replace((PsiElement)newContainer);
        CodeEditUtil.markToReformat((ASTNode)newContainer.getNode(), (boolean)true);
        editor.getCaretModel().moveToOffset(newContainer.getNavigationElement().getTextOffset());
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RubyFlattenNamespaceIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyFlattenNamespaceIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyFlattenNamespaceIntention.$$$reportNull$$$0(7);
        }
        if (TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element)) {
            return false;
        }
        RName name = (RName)PsiTreeUtil.getParentOfType((PsiElement)element, RName.class);
        if (name == null) {
            return false;
        }
        RContainer container = (RContainer)ObjectUtils.coalesce((Object)RClassNavigator.getByName((RName)name), (Object)RModuleNavigator.getByName((RName)name));
        if (container == null) {
            return false;
        }
        FQN nestedFqn = container.getFQNWithNesting();
        if (nestedFqn.equals((Object)name.getFQN()) || nestedFqn.getFullPath().contains("$")) {
            return false;
        }
        List comments = RubyCommentsUtilCore.getPsiComments((PsiElement)container);
        for (RContainer parentContainer = container.getParentContainer(); parentContainer != null && !(parentContainer instanceof RFile); parentContainer = parentContainer.getParentContainer()) {
            if (!(parentContainer instanceof RModule) || !RubyCommentsUtilCore.getPsiComments((PsiElement)parentContainer).isEmpty()) {
                return false;
            }
            RCompoundStatement compoundStatement = parentContainer.getCompoundStatement();
            if (compoundStatement.getStatements().size() != 1) {
                return false;
            }
            if (ContainerUtil.and((Iterable)PsiTreeUtil.getChildrenOfAnyType((PsiElement)compoundStatement, (Class[])new Class[]{PsiComment.class}), comments::contains)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/declarations/RubyFlattenNamespaceIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/declarations/RubyFlattenNamespaceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

