/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.controlFlow;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class TernaryOperatorToIfIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(TernaryOperatorToIfIntention.class);

    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.ternary.to.if");
        if (string == null) {
            TernaryOperatorToIfIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.ternary.to.if");
        if (string == null) {
            TernaryOperatorToIfIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TernaryOperatorToIfIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            TernaryOperatorToIfIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            TernaryOperatorToIfIntention.$$$reportNull$$$0(4);
        }
        if (TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element)) {
            return false;
        }
        RTernaryExpression ternaryOperator = (RTernaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, RTernaryExpression.class);
        if (ternaryOperator == null) {
            return false;
        }
        RPsiElement falseCommand = ternaryOperator.getFalseCommand();
        RPsiElement trueCommand = ternaryOperator.getTrueCommand();
        return falseCommand != null && trueCommand != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        String text;
        RExpression generated;
        RTernaryExpression ternary;
        if (project == null) {
            TernaryOperatorToIfIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            TernaryOperatorToIfIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            TernaryOperatorToIfIntention.$$$reportNull$$$0(7);
        }
        if ((ternary = (RTernaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, RTernaryExpression.class)) == null) {
            return;
        }
        RCondition condition = ternary.getCondition();
        RPsiElement trueCommand = ternary.getTrueCommand();
        RPsiElement falseCommand = ternary.getFalseCommand();
        if (condition == null || trueCommand == null || falseCommand == null) {
            return;
        }
        String conditionText = condition.getText();
        String thenBlockText = trueCommand.getText();
        String elseBlockText = falseCommand.getText();
        boolean needParentheses = PsiTreeUtil.getParentOfType((PsiElement)ternary.getParent(), RCall.class) != null && !(ternary.getParent() instanceof RGroupedExpression);
        StringBuilder builder2 = new StringBuilder();
        builder2.append(needParentheses ? "(if " : "if ").append(conditionText).append(" \n").append(thenBlockText).append(" else\n").append(elseBlockText).append("\n end");
        if (needParentheses) {
            builder2.append(")");
        }
        if (!((generated = RubyElementFactoryCore.createExpressionFromText((PsiElement)element, (String)(text = builder2.toString()))) instanceof RIfStatement) && !(generated instanceof RGroupedExpression)) {
            LOG.error("expected ternary expression, text: " + text);
        }
        ternary.replace((PsiElement)generated);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/TernaryOperatorToIfIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/TernaryOperatorToIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

