/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.controlFlow;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RIfStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RBinaryExpressionNavigator;

public final class RubySplitConditionIntoMultipleIfsIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.split.condition");
        if (string == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.split.condition");
        if (string == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(4);
        }
        RBoolBinExpression binaryExpression = RubySplitConditionIntoMultipleIfsIntention.getBoolBinaryExpressionByOperation(element);
        assert (binaryExpression != null && binaryExpression.getRightOperand() != null);
        RCondition condition = (RCondition)ObjectUtils.tryCast((Object)binaryExpression.getParent(), RCondition.class);
        assert (condition != null);
        RConditionalStatement conditionalStatement = (RConditionalStatement)condition.getParent();
        if (PsiUtilCore.getElementType((PsiElement)element) == RubyTokenTypesCore.tAND) {
            RCompoundStatement body;
            RCompoundStatement rCompoundStatement = body = conditionalStatement instanceof RIfStatement ? ((RIfStatement)conditionalStatement).getThenBlock() : ((RElsifBlock)conditionalStatement).getBody();
            assert (body != null);
            RIfStatement newIfStatement = (RIfStatement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)"if _\n_\nend");
            assert (newIfStatement.getCondition() != null && newIfStatement.getThenBlock() != null);
            newIfStatement.getCondition().getFirstChild().replace((PsiElement)RubySplitConditionIntoMultipleIfsIntention.removeParenthesisFromExpression(binaryExpression.getRightOperand()));
            newIfStatement.getThenBlock().replace((PsiElement)body);
            CodeEditUtil.markToReformat((ASTNode)newIfStatement.getNode(), (boolean)true);
            condition.getFirstChild().replace((PsiElement)RubySplitConditionIntoMultipleIfsIntention.removeParenthesisFromExpression(binaryExpression.getLeftOperand()));
            body.replace(newIfStatement.getParent());
        } else {
            RCompoundStatement body;
            RIfStatement ifStatement = (RIfStatement)ObjectUtils.coalesce((Object)RIfStatementNavigator.getByCondition((RCondition)condition), (Object)RIfStatementNavigator.getByElsifCondition((RCondition)condition));
            assert (ifStatement != null);
            RCompoundStatement rCompoundStatement = body = conditionalStatement instanceof RIfStatement ? ((RIfStatement)conditionalStatement).getThenBlock() : ((RElsifBlock)conditionalStatement).getBody();
            assert (body != null);
            RIfStatement newIfStatement = (RIfStatement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)"if _\nelsif _\n_\nend");
            RElsifBlock newElsifBlock = (RElsifBlock)newIfStatement.getElsifBlocks().get(0);
            assert (newElsifBlock.getCondition() != null);
            newElsifBlock.getCondition().getFirstChild().replace((PsiElement)RubySplitConditionIntoMultipleIfsIntention.removeParenthesisFromExpression(binaryExpression.getRightOperand()));
            newElsifBlock.getBody().replace(body.copy());
            CodeEditUtil.markToReformat((ASTNode)newElsifBlock.getNode(), (boolean)true);
            condition.getFirstChild().replace((PsiElement)RubySplitConditionIntoMultipleIfsIntention.removeParenthesisFromExpression(binaryExpression.getLeftOperand()));
            ifStatement.addRangeAfter(newElsifBlock.getPrevSibling(), (PsiElement)newElsifBlock, PsiTreeUtil.findPrevParent((PsiElement)ifStatement, (PsiElement)body));
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(7);
        }
        if (!TokenBNF.tBOOL_OPS.contains(PsiUtilCore.getElementType((PsiElement)element)) || TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element)) {
            return false;
        }
        RBoolBinExpression binaryExpression = RubySplitConditionIntoMultipleIfsIntention.getBoolBinaryExpressionByOperation(element);
        if (binaryExpression == null || binaryExpression.getRightOperand() == null) {
            return false;
        }
        RCondition condition = (RCondition)ObjectUtils.tryCast((Object)binaryExpression.getParent(), RCondition.class);
        if (condition == null) {
            return false;
        }
        RIfStatement ifStatement = (RIfStatement)ObjectUtils.coalesce((Object)RIfStatementNavigator.getByCondition((RCondition)condition), (Object)RIfStatementNavigator.getByElsifCondition((RCondition)condition));
        return ifStatement != null && ifStatement.getThenBlock() != null;
    }

    @Nullable
    private static RBoolBinExpression getBoolBinaryExpressionByOperation(@NotNull PsiElement element) {
        if (element == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(8);
        }
        return (RBoolBinExpression)ObjectUtils.tryCast((Object)RBinaryExpressionNavigator.getBinaryExpressionByOperation((PsiElement)element), RBoolBinExpression.class);
    }

    @NotNull
    private static RPsiElement removeParenthesisFromExpression(@NotNull RPsiElement element) {
        if (element == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(9);
        }
        if (element instanceof RGroupedExpression) {
            RPsiElement rPsiElement = (RPsiElement)ObjectUtils.coalesce((Object)((RGroupedExpression)element).getExpression(), (Object)element);
            if (rPsiElement == null) {
                RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(10);
            }
            return rPsiElement;
        }
        RPsiElement rPsiElement = element;
        if (rPsiElement == null) {
            RubySplitConditionIntoMultipleIfsIntention.$$$reportNull$$$0(11);
        }
        return rPsiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/RubySplitConditionIntoMultipleIfsIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/RubySplitConditionIntoMultipleIfsIntention";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeParenthesisFromExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBoolBinaryExpressionByOperation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeParenthesisFromExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

