/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.controlFlow;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;

public final class RubyMergeNestedIfsIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.merge.nested.ifs");
        if (string == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(3);
        }
        RConditionalStatement conditionalStatement = (RConditionalStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RConditionalStatement.class, (boolean)false);
        assert (conditionalStatement != null);
        RIfStatement nestedIfStatement = RubyMergeNestedIfsIntention.getNestedIfStatement(conditionalStatement);
        assert (nestedIfStatement != null);
        RCondition firstCondition = conditionalStatement.getCondition();
        RCondition secondCondition = nestedIfStatement.getCondition();
        assert (firstCondition != null && secondCondition != null);
        secondCondition.replace((PsiElement)RubyMergeNestedIfsIntention.createConjunctionCondition(firstCondition, secondCondition));
        for (RElsifBlock block : nestedIfStatement.getElsifBlocks()) {
            RCondition elsifCondition = block.getCondition();
            assert (elsifCondition != null);
            elsifCondition.replace((PsiElement)RubyMergeNestedIfsIntention.createConjunctionCondition(firstCondition, elsifCondition));
        }
        RElseBlock elseBlock = nestedIfStatement.getElseBlock();
        if (elseBlock != null) {
            String bodyText = elseBlock.getBody().getText();
            String text = String.format("if _\nelsif %s\n%s%send", firstCondition.getText(), bodyText, !bodyText.isEmpty() ? "\n" : "");
            RElsifBlock newElsifBlock = (RElsifBlock)((RIfStatement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)text)).getElsifBlocks().get(0);
            elseBlock.replace((PsiElement)newElsifBlock);
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        PsiElement endKeyword = nestedIfStatement.getLastChild();
        PsiElement eol = PsiTreeUtil.skipWhitespacesBackward((PsiElement)endKeyword);
        TextRange endRange = RubySpaceUtil.isEol((PsiElement)eol) ? endKeyword.getTextRange().union(eol.getTextRange()) : endKeyword.getTextRange();
        TextRange conditionRange = new TextRange(element.getTextRange().getEndOffset(), nestedIfStatement.getTextOffset() + 2);
        document.deleteString(endRange.getStartOffset(), endRange.getEndOffset());
        document.deleteString(conditionRange.getStartOffset(), conditionRange.getEndOffset());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int newEndOffset = endRange.getEndOffset() - endRange.getLength() - conditionRange.getLength();
        CodeStyleManager.getInstance((Project)project).reformatText(element.getContainingFile(), element.getTextOffset(), newEndOffset);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(6);
        }
        if (!Holder.IF_ELSIF_ELEMENT_TYPES.contains(PsiUtilCore.getElementType((PsiElement)element)) || TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element)) {
            return false;
        }
        RIfStatement ifStatement = (RIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RIfStatement.class, (boolean)false);
        if (ifStatement == null || ifStatement.getElseBlock() != null || PsiTreeUtil.getNextSiblingOfType((PsiElement)PsiTreeUtil.findPrevParent((PsiElement)ifStatement, (PsiElement)element), RElsifBlock.class) != null) {
            return false;
        }
        RConditionalStatement conditionalStatement = (RConditionalStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RConditionalStatement.class);
        if (conditionalStatement == null || conditionalStatement.getCondition() == null) {
            return false;
        }
        RCompoundStatement compoundStatement = RubyMergeNestedIfsIntention.getCompoundStatement(conditionalStatement);
        if (compoundStatement == null || PsiTreeUtil.countChildrenOfType((PsiElement)compoundStatement, PsiComment.class) > 0) {
            return false;
        }
        RIfStatement nestedIfStatement = RubyMergeNestedIfsIntention.getNestedIfStatement(conditionalStatement);
        if (nestedIfStatement == null || nestedIfStatement.getCondition() == null || ContainerUtil.or((Iterable)nestedIfStatement.getElsifBlocks(), block -> block.getCondition() == null)) {
            return false;
        }
        if (nestedIfStatement.getElsifBlocks().isEmpty() && nestedIfStatement.getElseBlock() == null) {
            this.setText(RBundle.message((String)"ruby.intentions.merge.nested.ifs"));
        } else {
            this.setText(RBundle.message((String)"ruby.intentions.merge.nested.ifs.changes.semantics"));
        }
        return true;
    }

    @NotNull
    private static RPsiElement createConjunctionCondition(@NotNull RCondition first, @NotNull RCondition second) {
        if (first == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(7);
        }
        if (second == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(8);
        }
        RPsiElement firstElement = (RPsiElement)ObjectUtils.coalesce((Object)((RPsiElement)ObjectUtils.tryCast((Object)first.getFirstChild(), RPsiElement.class)), (Object)first);
        RPsiElement secondElement = (RPsiElement)ObjectUtils.coalesce((Object)((RPsiElement)ObjectUtils.tryCast((Object)second.getFirstChild(), RPsiElement.class)), (Object)second);
        RBoolBinExpression newCondition = (RBoolBinExpression)RubyElementFactoryCore.createElementFromText((PsiElement)first, (String)"a && b");
        RPsiElement leftOperand = newCondition.getLeftOperand();
        if (RubyReplaceExpressionUtil.isNeedParenthesis(leftOperand, firstElement)) {
            leftOperand.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)first, (String)("(" + firstElement.getText() + ")")));
        } else {
            leftOperand.replace((PsiElement)firstElement);
        }
        RPsiElement rightOperand = newCondition.getRightOperand();
        assert (rightOperand != null);
        if (RubyReplaceExpressionUtil.isNeedParenthesis(rightOperand, secondElement)) {
            rightOperand.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)first, (String)("(" + secondElement.getText() + ")")));
        } else {
            rightOperand.replace((PsiElement)secondElement);
        }
        RBoolBinExpression rBoolBinExpression = newCondition;
        if (rBoolBinExpression == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(9);
        }
        return rBoolBinExpression;
    }

    @Nullable
    private static RCompoundStatement getCompoundStatement(@NotNull RConditionalStatement conditionalStatement) {
        if (conditionalStatement == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(10);
        }
        if (conditionalStatement instanceof RIfStatement) {
            return ((RIfStatement)conditionalStatement).getThenBlock();
        }
        if (conditionalStatement instanceof RElsifBlock) {
            return ((RElsifBlock)conditionalStatement).getBody();
        }
        return null;
    }

    @Nullable
    private static RIfStatement getNestedIfStatement(@NotNull RConditionalStatement conditionalStatement) {
        if (conditionalStatement == null) {
            RubyMergeNestedIfsIntention.$$$reportNull$$$0(11);
        }
        PsiElement statement = Optional.ofNullable(RubyMergeNestedIfsIntention.getCompoundStatement(conditionalStatement)).map(RCompoundStatement::getStatements).map(ContainerUtil::getOnlyItem).orElse(null);
        return (RIfStatement)ObjectUtils.tryCast((Object)statement, RIfStatement.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/RubyMergeNestedIfsIntention";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/RubyMergeNestedIfsIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConjunctionCondition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConjunctionCondition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCompoundStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNestedIfStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private static class Holder {
        private static final List<IElementType> IF_ELSIF_ELEMENT_TYPES = List.of(RubyTokenTypes.kIF, RubyTokenTypes.kELSIF);

        private Holder() {
        }
    }
}

