/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.controlFlow;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;

public final class IfToTernaryOperatorIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(IfToTernaryOperatorIntention.class);

    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.if.to.ternary");
        if (string == null) {
            IfToTernaryOperatorIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.if.to.ternary");
        if (string == null) {
            IfToTernaryOperatorIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            IfToTernaryOperatorIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            IfToTernaryOperatorIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            IfToTernaryOperatorIntention.$$$reportNull$$$0(4);
        }
        if (PsiUtilCore.getElementType((PsiElement)element) != RubyTokenTypes.kIF || TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element)) {
            return false;
        }
        RIfStatement ifStatement = (RIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RIfStatement.class);
        if (ifStatement == null) {
            return false;
        }
        RElseBlock elseBlock = ifStatement.getElseBlock();
        RCompoundStatement thenBlock = ifStatement.getThenBlock();
        return elseBlock != null && elseBlock.getBody().getStatements().size() == 1 && thenBlock != null && thenBlock.getStatements().size() == 1 && PsiTreeUtil.findChildOfType((PsiElement)thenBlock, RTernaryExpression.class) == null && ifStatement.getElsifBlocks().isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        RPsiElement then;
        RIfStatement ifStatement;
        if (project == null) {
            IfToTernaryOperatorIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            IfToTernaryOperatorIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            IfToTernaryOperatorIntention.$$$reportNull$$$0(7);
        }
        if ((ifStatement = (RIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RIfStatement.class)) == null) {
            return;
        }
        RCondition condition = ifStatement.getCondition();
        RCompoundStatement thenBlock = ifStatement.getThenBlock();
        RElseBlock elseBlock = ifStatement.getElseBlock();
        if (condition == null || thenBlock == null || elseBlock == null) {
            return;
        }
        Object conditionText = condition.getText();
        if (((String)conditionText).contains(" ") && (condition.getChildren().length != 1 || !(condition.getFirstChild() instanceof RGroupedExpression))) {
            conditionText = "(" + (String)conditionText + ")";
        }
        Object thenBlockText = (then = (RPsiElement)thenBlock.getStatements().get(0)) instanceof RModifierStatement ? "(" + then.getText() + ")" : then.getText();
        RCompoundStatement elseBody = elseBlock.getBody();
        Object elseBlockText = elseBody.getStatements().get(0) instanceof RModifierStatement ? "(" + elseBody.getText() + ")" : elseBody.getText();
        int len = ((String)conditionText).length() + ((String)thenBlockText).length() + ((String)elseBlockText).length() + 6;
        char separatorChar = len >= editor.getSettings().getRightMargin(project) ? (char)'\n' : ' ';
        String text = (String)conditionText + " ?" + separatorChar + (String)thenBlockText + " :" + separatorChar + (String)elseBlockText;
        RPsiElement withParent = RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)("(" + text + ")\n"));
        RPsiElement ternary = RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)(text + "\n"));
        if (!(ternary instanceof RTernaryExpression)) {
            LOG.error("expected ternary expression, text: " + text);
        }
        RPsiElement replacement = RubyReplaceExpressionUtil.isNeedParenthesis((RPsiElement)ifStatement, ternary) ? withParent : ternary;
        ifStatement.replace((PsiElement)replacement);
        CodeEditUtil.markToReformat((ASTNode)replacement.getNode(), (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/IfToTernaryOperatorIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/IfToTernaryOperatorIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

