/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.comments;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;

public final class RubyReplaceWithBlockCommentIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.replace.with.block.comment");
        if (string == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.replace.with.block.comment");
        if (string == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(4);
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element.getLanguage());
        String commentPrefix = RubyReplaceWithBlockCommentIntention.getCommentPrefix(editor, commenter, element);
        List<PsiComment> comments = RubyReplaceWithBlockCommentIntention.getComments((PsiComment)element);
        PsiComment firstComment = Objects.requireNonNull((PsiComment)ContainerUtil.getFirstItem(comments));
        PsiComment lastComment = Objects.requireNonNull((PsiComment)ContainerUtil.getLastItem(comments));
        Document document = editor.getDocument();
        document.insertString(lastComment.getTextOffset() + lastComment.getTextLength(), (CharSequence)StringUtil.notNullize((String)commenter.getBlockCommentSuffix()));
        for (PsiComment comment : ContainerUtil.reverse(comments)) {
            int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)comment.getText(), (CharSequence)commentPrefix);
            document.deleteString(comment.getTextOffset(), comment.getTextOffset() + commonPrefixLength);
        }
        document.insertString(firstComment.getTextOffset(), (CharSequence)StringUtil.notNullize((String)commenter.getBlockCommentPrefix()));
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(7);
        }
        if (LanguageCommenters.INSTANCE.forLanguage(element.getLanguage()) == null) {
            return false;
        }
        if (PsiUtilCore.getElementType((PsiElement)element) != RubyTokenTypes.TLINE_COMMENT) {
            return false;
        }
        List<PsiComment> comments = RubyReplaceWithBlockCommentIntention.getComments((PsiComment)element);
        Document document = editor.getDocument();
        return ContainerUtil.all(comments, comment -> DocumentUtil.isAtLineStart((int)comment.getTextOffset(), (Document)document));
    }

    private static List<PsiComment> getComments(@NotNull PsiComment comment) {
        if (comment == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(8);
        }
        LinkedList<PsiComment> comments = new LinkedList<PsiComment>();
        comments.add(comment);
        PsiComment previousComment = comment;
        while ((previousComment = RubyCommentsUtilCore.getPrevComment((PsiElement)previousComment, (IElementType)RubyTokenTypes.TLINE_COMMENT)) != null) {
            comments.add(0, previousComment);
        }
        PsiComment nextComment = comment;
        while ((nextComment = RubyCommentsUtil.getNextComment((PsiElement)nextComment, RubyTokenTypes.TLINE_COMMENT)) != null) {
            comments.add(nextComment);
        }
        return comments;
    }

    @NotNull
    private static String getCommentPrefix(@NotNull Editor editor, @NotNull Commenter commenter, @NotNull PsiElement context) {
        if (editor == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(9);
        }
        if (commenter == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(10);
        }
        if (context == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(11);
        }
        String prefix = StringUtil.notNullize((String)commenter.getLineCommentPrefix());
        boolean addSpace = CodeStyle.getSettings((Editor)editor).getCommonSettings((Language)context.getLanguage()).LINE_COMMENT_ADD_SPACE;
        Object object = addSpace ? prefix + " " : prefix;
        if (object == null) {
            RubyReplaceWithBlockCommentIntention.$$$reportNull$$$0(12);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/comments/RubyReplaceWithBlockCommentIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/comments/RubyReplaceWithBlockCommentIntention";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getComments";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

