/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.actions.intention.RubyMutablyNamedIntention;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBeginEndBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;

public final class StatementToModifierIntention
extends RubyMutablyNamedIntention<RConditionalStatement>
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(StatementToModifierIntention.class);

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.statement.to.modifier.familyName");
        if (string == null) {
            StatementToModifierIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected RConditionalStatement findMatchingElement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            StatementToModifierIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            StatementToModifierIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            StatementToModifierIntention.$$$reportNull$$$0(3);
        }
        if (TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element)) {
            return null;
        }
        RConditionalStatement statement = (RConditionalStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RConditionalStatement.class, (boolean)false, (Class[])new Class[]{RBeginEndBlockStatement.class, RCodeBlock.class});
        return StatementToModifierIntention.getBodyIfAvailable(statement) != null ? statement : null;
    }

    @Override
    @Nullable
    protected String getTextForElement(@NotNull RConditionalStatement statement) {
        if (statement == null) {
            StatementToModifierIntention.$$$reportNull$$$0(4);
        }
        if (statement instanceof RIfStatement) {
            return RBundle.message((String)"ruby.intentions.statement.to.modifier", (Object[])new Object[]{"if"});
        }
        if (statement instanceof RUnlessStatement) {
            return RBundle.message((String)"ruby.intentions.statement.to.modifier", (Object[])new Object[]{"unless"});
        }
        return null;
    }

    @Nullable
    private static RCompoundStatement getBodyIfAvailable(RConditionalStatement statement) {
        RUnlessStatement unlessStatement;
        if (statement == null) {
            return null;
        }
        if (statement instanceof RIfStatement) {
            RIfStatement ifStatement = (RIfStatement)statement;
            RCompoundStatement thenBlock = ifStatement.getThenBlock();
            if (ifStatement.getElseBlock() == null && ifStatement.getElsifBlocks().isEmpty() && thenBlock != null && thenBlock.getStatements().size() == 1) {
                return thenBlock;
            }
        }
        if (statement instanceof RUnlessStatement && (unlessStatement = (RUnlessStatement)statement).getElseBlock() == null && unlessStatement.getThenBlock().getStatements().size() == 1) {
            return unlessStatement.getThenBlock();
        }
        return null;
    }

    @Nullable
    private static String getName(RConditionalStatement statement) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof RIfStatement) {
            return "if";
        }
        if (statement instanceof RUnlessStatement) {
            return "unless";
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        RCondition condition;
        if (project == null) {
            StatementToModifierIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            StatementToModifierIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            StatementToModifierIntention.$$$reportNull$$$0(7);
        }
        RConditionalStatement statement = this.findMatchingElement(project, editor, element);
        RCompoundStatement compoundStatement = StatementToModifierIntention.getBodyIfAvailable(statement);
        if (statement == null || (condition = statement.getCondition()) == null || compoundStatement == null) {
            return;
        }
        String text = ((RPsiElement)compoundStatement.getStatements().get(0)).getText() + " " + StatementToModifierIntention.getName(statement) + " " + condition.getText();
        RPsiElement modifierStatement = RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)text);
        if (!(modifierStatement instanceof RModifierStatement)) {
            LOG.error("expected modifier statement, text: " + text + "; type = " + String.valueOf(modifierStatement));
        }
        statement.replace((PsiElement)modifierStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/StatementToModifierIntention";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/StatementToModifierIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextForElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

