/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RPropertyType;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RubyClassMemberImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.utils.RubyPropertiesUtil;

public abstract class RubyGeneratePropertyHandler {
    @NlsContexts.HintText
    public abstract String getNothingFoundMessage();

    @NlsContexts.DialogTitle
    public abstract String getTitle();

    public abstract RPropertyType getPropertyType();

    public boolean isValidFor(@NotNull Editor editor, @NotNull RClass rClass) {
        if (editor == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(0);
        }
        if (rClass == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void performRefactoring(@NotNull Project project, @NotNull Editor editor, @NotNull RClass rClass, @NotNull UnaryOperator<List<ClassMember>> select) {
        List<ClassMember> members;
        if (project == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(3);
        }
        if (rClass == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(4);
        }
        if (select == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(5);
        }
        if ((members = this.collectMembers(rClass)).isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, this.getNothingFoundMessage());
            return;
        }
        List selected = (List)select.apply(members);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (selected.isEmpty()) {
                return;
            }
            for (ClassMember member : selected) {
                String name = member.getText();
                this.insertAccessor(name, rClass);
            }
        });
    }

    public void insertAccessor(@NotNull String name, @NotNull RClass rClass) {
        PsiElement newElement;
        if (name == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(6);
        }
        if (rClass == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(7);
        }
        String newText = ":" + name;
        RPropertyType type = this.getPropertyType();
        if (type == RPropertyType.READER) {
            if (RubyPropertiesUtil.removeProperty(name, rClass, RPropertyType.WRITER)) {
                type = RPropertyType.ACCESSOR;
            }
        } else if (type == RPropertyType.WRITER) {
            if (RubyPropertiesUtil.removeProperty(name, rClass, RPropertyType.READER)) {
                type = RPropertyType.ACCESSOR;
            }
        } else {
            RubyPropertiesUtil.removeProperty(name, rClass, RPropertyType.READER);
            RubyPropertiesUtil.removeProperty(name, rClass, RPropertyType.WRITER);
        }
        RCall rCall = RubyPropertiesUtil.findFirstPropertyDeclaration(rClass, type);
        RBodyStatement body = ((RClassBase)rClass).getBody();
        if (rCall != null) {
            RExpression expr = RubyElementFactoryCore.createExpressionFromText((PsiElement)rClass, (String)(rCall.getText() + ", " + newText));
            newElement = rCall.replace((PsiElement)expr);
        } else {
            RExpression expr = RubyElementFactoryCore.createExpressionFromText((PsiElement)rClass, (String)(String.valueOf((Object)type) + " " + newText));
            newElement = rClass.addBefore((PsiElement)expr, (PsiElement)body);
        }
        CodeStyleManager.getInstance((Project)rClass.getProject()).reformatText(newElement.getContainingFile(), newElement.getTextRange().getStartOffset(), newElement.getTextRange().getEndOffset());
    }

    @NotNull
    public List<ClassMember> selectMembers(@NotNull Project project, @NotNull List<ClassMember> members) {
        if (project == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(8);
        }
        if (members == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(9);
        }
        MemberChooser chooser = new MemberChooser(members.toArray(ClassMember.EMPTY_ARRAY), false, true, project);
        chooser.setTitle(this.getTitle());
        chooser.setCopyJavadocVisible(false);
        if (!chooser.showAndGet()) {
            List<ClassMember> list = Collections.emptyList();
            if (list == null) {
                RubyGeneratePropertyHandler.$$$reportNull$$$0(10);
            }
            return list;
        }
        List elements = chooser.getSelectedElements();
        if (elements == null) {
            List<ClassMember> list = Collections.emptyList();
            if (list == null) {
                RubyGeneratePropertyHandler.$$$reportNull$$$0(11);
            }
            return list;
        }
        List list = elements;
        if (list == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    protected List<ClassMember> collectMembers(RClass rClass) {
        ArrayList<ClassMember> result = new ArrayList<ClassMember>();
        List instanceVariables = rClass.getFieldsDeclarations();
        if (!instanceVariables.isEmpty()) {
            String name;
            RPropertyType type = this.getPropertyType();
            List<Symbol> symbols = switch (type) {
                default -> throw new MatchException(null, null);
                case RPropertyType.READER -> RubyPropertiesUtil.getReaders(rClass);
                case RPropertyType.WRITER -> RubyPropertiesUtil.getWriters(rClass);
                case RPropertyType.ACCESSOR -> RubyPropertiesUtil.getAccessors(rClass);
            };
            ArrayList<String> names = new ArrayList<String>();
            for (Symbol symbol : symbols) {
                name = RubyPropertiesUtil.getPropertyName(symbol);
                if (name == null) continue;
                names.add(name);
            }
            for (RField field : instanceVariables) {
                name = field.getName();
                if (name == null || names.contains(name)) continue;
                result.add((ClassMember)new RubyClassMemberImpl(field));
            }
            ArrayList<ClassMember> arrayList = result;
            if (arrayList == null) {
                RubyGeneratePropertyHandler.$$$reportNull$$$0(13);
            }
            return arrayList;
        }
        List<ClassMember> list = Collections.emptyList();
        if (list == null) {
            RubyGeneratePropertyHandler.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "select";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/generate/RubyGeneratePropertyHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/generate/RubyGeneratePropertyHandler";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMembers";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertAccessor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectMembers";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

