/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RubyGeneratePropertyHandler;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public abstract class RubyGenerateInClassBase
extends AnAction {
    @NotNull
    protected abstract RubyGeneratePropertyHandler getGenerateHandler();

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RubyGenerateInClassBase.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        Editor editor = RubyGenerateInClassBase.getEditor(e);
        assert (editor != null);
        this.performAction(project, editor, (handler, members) -> handler.selectMembers(project, (List<ClassMember>)members));
    }

    public void performAction(@NotNull Project project, @NotNull Editor editor, @NotNull BiFunction<? super RubyGeneratePropertyHandler, ? super List<ClassMember>, List<ClassMember>> select) {
        if (project == null) {
            RubyGenerateInClassBase.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            RubyGenerateInClassBase.$$$reportNull$$$0(2);
        }
        if (select == null) {
            RubyGenerateInClassBase.$$$reportNull$$$0(3);
        }
        RClass rClass = RubyGenerateInClassBase.getRClass(editor);
        assert (rClass != null);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
                return;
            }
            RubyGeneratePropertyHandler handler = this.getGenerateHandler();
            handler.performRefactoring(project, editor, rClass, members -> (List)select.apply(handler, (List<ClassMember>)members));
        }, this.getCommandName(), (Object)DocCommandGroupId.noneGroupId((Document)editor.getDocument()));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RubyGenerateInClassBase.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    public final void update(@NotNull AnActionEvent e) {
        RubyGeneratePropertyHandler handler;
        RClass rClass;
        if (e == null) {
            RubyGenerateInClassBase.$$$reportNull$$$0(5);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = RubyGenerateInClassBase.getEditor(e);
        if (project != null && editor != null && (rClass = RubyGenerateInClassBase.getRClass(editor)) != null && (handler = this.getGenerateHandler()).isValidFor(editor, rClass)) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    @Nullable
    public static RClass getRClass(@NotNull Editor editor) {
        PsiElement element;
        if (editor == null) {
            RubyGenerateInClassBase.$$$reportNull$$$0(6);
        }
        if ((element = PsiUtilBase.getElementAtCaret((Editor)editor)) != null) {
            return (RClass)PsiTreeUtil.getParentOfType((PsiElement)element, RClass.class);
        }
        return null;
    }

    @Nullable
    protected static Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            RubyGenerateInClassBase.$$$reportNull$$$0(7);
        }
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    @NlsContexts.Command
    protected String getCommandName() {
        String name = this.getTemplatePresentation().getDescription();
        if (name == null) {
            name = RBundle.message((String)"command.name.generate.description", (Object[])new Object[]{this.getTemplatePresentation().getText()});
        }
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "select";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/generate/RubyGenerateInClassBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/generate/RubyGenerateInClassBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

