/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.actions.editor.RubyEditorAction;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class ToggleCamelSnakeCaseAction
extends RubyEditorAction {
    public ToggleCamelSnakeCaseAction() {
        this.setEnabledInModalContext(true);
    }

    @Override
    public void execute(@NotNull Caret caret) {
        if (caret == null) {
            ToggleCamelSnakeCaseAction.$$$reportNull$$$0(0);
        }
        if (!caret.hasSelection()) {
            return;
        }
        VirtualFile vFile = caret.getEditor().getVirtualFile();
        Project project = caret.getEditor().getProject();
        Module module = project != null && vFile != null ? ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project) : null;
        String text = caret.getSelectedText();
        int start = caret.getSelectionStart();
        String changedText = NamingConventions.isInUnderscoredCaseExt((String)text) ? NamingConventions.toCamelCase((String)text, (Module)module) : NamingConventions.toUnderscoreCase((String)text, (Module)module);
        EditorModificationUtilEx.insertStringAtCaret((Editor)caret.getEditor(), (String)changedText, (boolean)true, (boolean)true);
        caret.setSelection(start, start + changedText.length());
    }

    @Override
    public String getId() {
        return "toggle_camel_snake_case";
    }

    @Override
    public String[] getFileTypes() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "org/jetbrains/plugins/ruby/ruby/actions/editor/ToggleCamelSnakeCaseAction", "execute"));
    }
}

