/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.commands;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.ide.actions.runAnything.commands.RunAnythingCommandCustomizer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;

public final class RubyRunAnythingCommandCustomizer
extends RunAnythingCommandCustomizer {
    private static final Logger LOG = Logger.getInstance(RubyRunAnythingCommandCustomizer.class);

    @NotNull
    public GeneralCommandLine customizeCommandLine(@NotNull VirtualFile workDirectory, @NotNull DataContext dataContext, @NotNull GeneralCommandLine commandLine) {
        if (workDirectory == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(1);
        }
        if (commandLine == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(2);
        }
        GeneralCommandLine generalCommandLine = RubyRunAnythingCommandCustomizer.patchOrWrapWithLoginShell(RubyRunAnythingCommandCustomizer.customizeWithVersionManagers(commandLine, (Module)PlatformCoreDataKeys.MODULE.getData(dataContext))).withWorkDirectory(workDirectory.getPath());
        if (generalCommandLine == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(3);
        }
        return generalCommandLine;
    }

    @NotNull
    private static GeneralCommandLine patchOrWrapWithLoginShell(@NotNull GeneralCommandLine commandLine) {
        String pathEnvVariableName;
        ArrayList<String> shellCommands;
        if (commandLine == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(4);
        }
        if ((shellCommands = new ArrayList<String>(RubyRunAnythingCommandCustomizer.getShellCommand())).isEmpty()) {
            GeneralCommandLine generalCommandLine = commandLine;
            if (generalCommandLine == null) {
                RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(5);
            }
            return generalCommandLine;
        }
        ArrayList commandLineList = new ArrayList(commandLine.getCommandLineList(null));
        if (commandLineList.size() == 3 && "-c".equals(commandLineList.get(1)) && StringUtil.notNullize((String)((String)commandLineList.get(0))).endsWith("sh")) {
            commandLineList.remove(0);
            commandLineList.remove(0);
        }
        Object command = commandLineList.size() > 1 ? new GeneralCommandLine(commandLineList).getCommandLineString() : (String)commandLineList.remove(0);
        Map environment = commandLine.getEnvironment();
        String customPathValue = (String)environment.get(pathEnvVariableName = (String)ObjectUtils.notNull((Object)OSUtil.getPathEnvVariableName(), (Object)"PATH"));
        if (StringUtil.isNotEmpty((String)customPathValue)) {
            if (SystemInfo.isWindows) {
                String currentPathValue = EnvironmentUtil.getValue((String)pathEnvVariableName);
                if (StringUtil.isNotEmpty((String)currentPathValue)) {
                    environment.put(pathEnvVariableName, customPathValue + ";" + currentPathValue);
                }
            } else {
                command = "export PATH=" + customPathValue + ":$PATH && " + (String)command;
                environment.remove(pathEnvVariableName);
            }
        }
        if (!SystemInfo.isWindows && RubyVersionManagerHandler.shouldRemoveGemHome(commandLine)) {
            command = "unset GEM_HOME && unset GEM_PATH && " + (String)command;
        }
        shellCommands.add((String)command);
        commandLine.setExePath((String)shellCommands.remove(0));
        ParametersList parametersList = commandLine.getParametersList();
        parametersList.clearAll();
        parametersList.addAll(shellCommands);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(6);
        }
        return generalCommandLine;
    }

    @NotNull
    private static GeneralCommandLine customizeWithVersionManagers(@NotNull GeneralCommandLine commandLine, @Nullable Module module) {
        if (commandLine == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(7);
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (!Experiments.getInstance().isFeatureEnabled("ruby.run.anything.remote.sdk.enabled") && RubyRemoteInterpreterManager.isRemoteSdk(sdk)) {
            GeneralCommandLine generalCommandLine = commandLine;
            if (generalCommandLine == null) {
                RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(8);
            }
            return generalCommandLine;
        }
        RubyVersionManagerHandler versionManagerHandler = RubyVersionManagerHandler.from(sdk);
        if (versionManagerHandler == null) {
            GeneralCommandLine generalCommandLine = commandLine;
            if (generalCommandLine == null) {
                RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(9);
            }
            return generalCommandLine;
        }
        if (versionManagerHandler.canRunArbitraryCommand()) {
            return RubyRunAnythingCommandCustomizer.doPatchWithVersionManager(sdk, commandLine);
        }
        if (versionManagerHandler instanceof ShimsBasedVersionManagerHandler) {
            String executablePath;
            String executableName;
            Path shimsPath = ((ShimsBasedVersionManagerHandler)((Object)versionManagerHandler)).computeShimsPath(sdk);
            if (!Files.exists(shimsPath.resolve(executableName = Paths.get(executablePath = commandLine.getExePath(), new String[0]).getFileName().toString()), new LinkOption[0])) {
                GeneralCommandLine generalCommandLine = commandLine;
                if (generalCommandLine == null) {
                    RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(10);
                }
                return generalCommandLine;
            }
            commandLine.setExePath(executableName);
            return RubyRunAnythingCommandCustomizer.doPatchWithVersionManager(sdk, commandLine);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(11);
        }
        return generalCommandLine;
    }

    @NotNull
    private static GeneralCommandLine doPatchWithVersionManager(@NotNull Sdk sdk, @NotNull GeneralCommandLine commandLine) {
        if (sdk == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(12);
        }
        if (commandLine == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(13);
        }
        RubyAbstractRunner rubyRunner = (RubyAbstractRunner)RubyRunner.notNullFrom(sdk);
        try {
            RubyVersionManagerHandler.notNullFrom(sdk).doPatchCommandLine(rubyRunner, commandLine, commandLine.getEnvironment(), Collections.emptyMap(), sdk, rubyRunner.addDefaultMappings(null));
        }
        catch (ExecutionException e) {
            LOG.warn("Error patching command line for " + String.valueOf(sdk), (Throwable)e);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(14);
        }
        return generalCommandLine;
    }

    @NotNull
    private static List<String> getShellCommand() {
        if (SystemInfo.isWindows) {
            List<String> list = List.of(CommandLineUtil.getWinShellName(), "/c");
            if (list == null) {
                RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(15);
            }
            return list;
        }
        String shell = EnvironmentUtil.getValue((String)"SHELL");
        if (shell == null || !new File(shell).canExecute()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(16);
            }
            return list;
        }
        SmartList commands = new SmartList((Object)shell);
        if (Registry.is((String)"run.anything.bash.login.mode", (boolean)false) && !shell.endsWith("/tcsh") && !shell.endsWith("/csh")) {
            commands.add("--login");
        }
        commands.add("-c");
        SmartList smartList = commands;
        if (smartList == null) {
            RubyRunAnythingCommandCustomizer.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 8, 9, 10, 11, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/commands/RubyRunAnythingCommandCustomizer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/commands/RubyRunAnythingCommandCustomizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "customizeCommandLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "patchOrWrapWithLoginShell";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "customizeWithVersionManagers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doPatchWithVersionManager";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCommandLine";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "patchOrWrapWithLoginShell";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customizeWithVersionManagers";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doPatchWithVersionManager";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 8, 9, 10, 11, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

