/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.PlatformUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public abstract class RubyScriptAction
extends AnAction {
    protected abstract void doActionPerformed(@NotNull AnActionEvent var1);

    protected RubyScriptAction() {
        this(null);
    }

    protected RubyScriptAction(@Nullable Icon icon) {
        this.getTemplatePresentation().setIcon(icon);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            RubyScriptAction.$$$reportNull$$$0(0);
        }
        if (!this.checkPrerequisites(event)) {
            return;
        }
        this.doActionPerformed(event);
    }

    protected boolean checkPrerequisites(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        Module module = RModuleUtil.getInstance().getModule(event.getDataContext());
        if (module == null) {
            String msg = RubyScriptAction.choseMsgForCurrentBundle(RBundle.message((String)"actions.types.ruby.script.errors.no.module.in.context.rubymine"), RBundle.message((String)"actions.types.ruby.script.errors.no.module.in.context.ruby.plugin"));
            Messages.showErrorDialog((Project)project, (String)msg, (String)RubyScriptAction.getErrorTitle());
            return false;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            String msg = RubyScriptAction.choseMsgForCurrentBundle(RBundle.message((String)"actions.types.ruby.script.errors.no.sdk.in.context.rubymine"), RBundle.message((String)"actions.types.ruby.script.errors.no.sdk.in.context.ruby.plugin"));
            if (Messages.showYesNoDialog((Project)project, (String)msg, (String)RubyScriptAction.getErrorTitle(), (Icon)Messages.getErrorIcon()) == 0) {
                ProjectSettingsService.getInstance((Project)module.getProject()).openModuleSettings(module);
            }
            return false;
        }
        return true;
    }

    @NlsContexts.DialogMessage
    protected static String choseMsgForCurrentBundle(@NlsContexts.DialogMessage @NotNull String msgRubyMine, @NlsContexts.DialogMessage @NotNull String msgRubyPlugin) {
        if (msgRubyMine == null) {
            RubyScriptAction.$$$reportNull$$$0(1);
        }
        if (msgRubyPlugin == null) {
            RubyScriptAction.$$$reportNull$$$0(2);
        }
        return PlatformUtils.isRubyMine() ? msgRubyMine : msgRubyPlugin;
    }

    @NlsContexts.DialogTitle
    protected static String getErrorTitle() {
        return RBundle.message((String)"actions.types.ruby.script.errors.execution.error.title");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RubyScriptAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            RubyScriptAction.$$$reportNull$$$0(4);
        }
        RubyScriptAction.setEnableAndVisibilityFlags(event);
    }

    public static void setEnableAndVisibilityFlags(AnActionEvent event) {
        boolean isVisible;
        if (PlatformUtils.isRubyMine()) {
            isVisible = true;
        } else {
            Module module = RModuleUtil.getInstance().getModule(event.getDataContext());
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            isVisible = sdk != null;
        }
        event.getPresentation().setVisible(isVisible);
        boolean isEnabled = isVisible;
        event.getPresentation().setEnabled(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msgRubyMine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msgRubyPlugin";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/RubyScriptAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/RubyScriptAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "choseMsgForCurrentBundle";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

