/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;
import org.jetbrains.plugins.ruby.testing.actions.RubyElementListCellRenderer;

public final class RubyGotoSuperHandler
implements LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile file) {
        return RubyGotoSuperHandler.findElementAndSymbol(editor, file) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiElement element;
        if (project == null) {
            RubyGotoSuperHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RubyGotoSuperHandler.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            RubyGotoSuperHandler.$$$reportNull$$$0(2);
        }
        if ((element = psiFile.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return;
        }
        RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)element, RMethod.class);
        if (method != null) {
            NavigatablePsiElement[] superMethods = (NavigatablePsiElement[])RubySuperMethodsSearch.search(method).mapping(symbol -> (NavigatablePsiElement)ObjectUtils.tryCast((Object)symbol.getPsiElement(), NavigatablePsiElement.class)).filtering(Objects::nonNull).toArray((Object[])NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY);
            if (superMethods.length == 1) {
                superMethods[0].navigate(true);
            } else if (superMethods.length > 1) {
                PsiElementListNavigator.openTargets((Editor)editor, (NavigatablePsiElement[])superMethods, (String)CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"goto.super.method.findUsages.title", (Object[])new Object[]{superMethods[0].getName()}), (ListCellRenderer)((Object)new RubyElementListCellRenderer()));
            }
        } else {
            List<RClass> superClasses;
            RClass clazz = (RClass)PsiTreeUtil.getParentOfType((PsiElement)element, RClass.class);
            if (clazz != null && !(superClasses = RubyClassResolveUtil.resolveSuperClass(clazz, element)).isEmpty()) {
                superClasses.get(0).navigate(true);
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static Pair<PsiElement, Symbol> findElementAndSymbol(Editor editor, PsiFile file) {
        return RubyGotoSuperHandler.findElementAndSymbol(editor, file, false);
    }

    @Nullable
    public static Pair<PsiElement, Symbol> findElementAndSymbol(Editor editor, PsiFile file, boolean skipMethod) {
        Type type;
        if (DumbService.getInstance((Project)file.getProject()).isDumb()) {
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        RContainer container = skipMethod ? RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)element) : (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, RContainer.class);
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
        Type type2 = type = symbol != null ? symbol.getType() : null;
        if (type == Type.CLASS || type == Type.INSTANCE_METHOD || type == Type.CLASS_METHOD) {
            return Pair.create((Object)element, (Object)symbol);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/actions/RubyGotoSuperHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

