/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import icons.RubyIcons;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.templates.RubyCreateFileFromTemplateAction;
import org.jetbrains.plugins.ruby.statistic.RubyCreateFileFromTemplateCollector;

public final class RubyCreateClassFileAction
extends RubyCreateFileFromTemplateAction
implements DumbAware {
    @VisibleForTesting
    @ApiStatus.Internal
    public static final InputValidatorEx CONSTANT_VALIDATOR = new InputValidatorEx(){

        public boolean canClose(@NotNull String input) {
            if (input == null) {
                1.$$$reportNull$$$0(0);
            }
            return StringUtil.isNotEmpty((String)input) && this.getErrorText(input) == null;
        }

        public boolean checkInput(@NotNull String input) {
            if (input == null) {
                1.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Nullable
        public String getErrorText(@NotNull String input) {
            if (input == null) {
                1.$$$reportNull$$$0(2);
            }
            if (!TextUtil.isCIDOrColonQualifiedReference((String)input)) {
                return RBundle.message((String)"ruby.action.create.new.class.file.dialog.invalid.name");
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "input";
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/RubyCreateClassFileAction$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkInput";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrorText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final InputValidatorEx FILE_VALIDATOR = new InputValidatorEx(){

        public boolean canClose(@NotNull String input) {
            if (input == null) {
                2.$$$reportNull$$$0(0);
            }
            return StringUtil.isNotEmpty((String)input) && this.getErrorText(input) == null;
        }

        public boolean checkInput(@NotNull String input) {
            if (input == null) {
                2.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Nullable
        public String getErrorText(@NotNull String input) {
            if (input == null) {
                2.$$$reportNull$$$0(2);
            }
            if (!PathUtil.isValidFileName((String)input)) {
                return RBundle.message((String)"ruby.action.create.new.class.file.dialog.invalid.filename");
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "input";
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/RubyCreateClassFileAction$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkInput";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrorText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public RubyCreateClassFileAction() {
        super(RBundle.messagePointer((String)"ruby.action.create.new.class.file.text"), RBundle.messagePointer((String)"ruby.action.create.new.class.file.description"), AllIcons.Nodes.Class);
    }

    @VisibleForTesting
    @Nullable
    public PsiFile createFile(@NotNull String name, @NotNull String templateName, @NotNull PsiDirectory dir) {
        if (name == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(0);
        }
        if (templateName == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(1);
        }
        if (dir == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(2);
        }
        return super.createFile(name, templateName, dir);
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder2) {
        if (project == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(4);
        }
        if (builder2 == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(5);
        }
        builder2.setTitle(RBundle.message((String)"ruby.action.create.new.class.file.dialog.title")).addKind(RBundle.message((String)"dialog.kind.class1"), AllIcons.Nodes.Class, "Ruby Class", (InputValidator)CONSTANT_VALIDATOR).addKind(RBundle.message((String)"dialog.kind.module1"), RubyIcons.Ruby.Nodes.Module, "Ruby Module", (InputValidator)CONSTANT_VALIDATOR).addKind(RBundle.message((String)"dialog.kind.file"), RubyIcons.Ruby.RubyFile, "Ruby File", (InputValidator)FILE_VALIDATOR);
    }

    @Nullable
    protected PsiFile createFileFromTemplate(@NotNull String name, @NotNull FileTemplate template, @NotNull PsiDirectory dir) {
        if (name == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(6);
        }
        if (template == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(8);
        }
        RubyCreateFileFromTemplateCollector.logCreatedEvent(template);
        if (template.getName().equals("Ruby File")) {
            return RubyCreateClassFileAction.createFileFromTemplate((String)name, (FileTemplate)template, (PsiDirectory)dir, null, (boolean)true);
        }
        return RubyCreateClassFileAction.createFileFromClassOrModuleTemplate(template, name, dir);
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName, @NotNull String templateName) {
        if (directory == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(10);
        }
        if (templateName == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(11);
        }
        String string = RBundle.message((String)"ruby.action.create.new.class.file.name", (Object[])new Object[]{newName});
        if (string == null) {
            RubyCreateClassFileAction.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/RubyCreateClassFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/RubyCreateClassFileAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildDialog";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromTemplate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

