/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;

public final class RubyUtil {
    private static final Logger LOG = Logger.getInstance(RubyUtil.class);
    private static final Set<String> KNOWN_RUBY_ROOTS = new HashSet<String>();
    private static final String RUBY_PLUGIN_ID = "org.jetbrains.plugins.ruby";
    @NonNls
    public static final String RUBYOPT = "RUBYOPT";

    private RubyUtil() {
    }

    @NotNull
    public static Path getRubyPluginHomePath() {
        Path pluginHomePath = null;
        if (PluginManagerCore.isRunningFromSources()) {
            String jarPath = PathUtil.getJarPathForClass(RubyUtil.class);
            pluginHomePath = Path.of(jarPath, new String[0]);
            LOG.debug("Plugin home path while running from sources: ", new Object[]{pluginHomePath});
        } else {
            PluginId id = PluginId.findId((String)RUBY_PLUGIN_ID);
            if (id == null) {
                LOG.warn("Invalid plugin ID 'org.jetbrains.plugins.ruby");
            } else {
                IdeaPluginDescriptor plugin = (IdeaPluginDescriptor)Cancellation.forceNonCancellableSectionInClassInitializer(() -> PluginManager.getInstance().findEnabledPlugin(id));
                if (plugin == null) {
                    LOG.warn("No plugin not found with ID: " + String.valueOf(id));
                } else {
                    pluginHomePath = plugin.getPluginPath();
                    LOG.debug("Plugin home path: ", new Object[]{pluginHomePath});
                }
            }
            if (pluginHomePath == null) {
                String jarPath = PathUtil.getJarPathForClass(RubyUtil.class);
                pluginHomePath = Objects.requireNonNull(Path.of(jarPath, new String[0]).getParent().getParent());
                LOG.warn("Failed to get plugin's home path properly, so falling back to: " + String.valueOf(pluginHomePath));
            }
        }
        LOG.assertTrue(Files.exists(pluginHomePath, new LinkOption[0]), (Object)("Invalid path: " + String.valueOf(pluginHomePath)));
        Path path = pluginHomePath;
        if (path == null) {
            RubyUtil.$$$reportNull$$$0(0);
        }
        return path;
    }

    @Nullable
    public static Map loadYaml(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            RubyUtil.$$$reportNull$$$0(1);
        }
        return (Map)new Yaml((BaseConstructor)new Constructor(HashMap.class, new LoaderOptions()){

            protected Class<?> getClassForNode(Node node) {
                try {
                    return super.getClassForNode(node);
                }
                catch (YAMLException e) {
                    return HashMap.class;
                }
            }
        }).load(inputStream);
    }

    @NotNull
    public static Set<String> getScriptBasePaths() {
        Set<String> set = Collections.unmodifiableSet(KNOWN_RUBY_ROOTS);
        if (set == null) {
            RubyUtil.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Nullable
    public static String getScriptFullPath(@NotNull String scriptPath) {
        if (scriptPath == null) {
            RubyUtil.$$$reportNull$$$0(3);
        }
        Set<String> basePaths = RubyUtil.getScriptBasePaths();
        for (String basePath : basePaths) {
            File file = new File(basePath, scriptPath);
            if (!file.exists()) continue;
            return file.getPath();
        }
        File fileByAbsPath = new File(scriptPath);
        if (fileByAbsPath.exists()) {
            return fileByAbsPath.getPath();
        }
        LOG.error("Could not find '" + scriptPath + "' in base paths: " + String.valueOf(basePaths));
        return null;
    }

    public static List<String> getBuiltinScriptFolders() {
        ArrayList<String> list = new ArrayList<String>();
        Set<String> basePaths = RubyUtil.getScriptBasePaths();
        for (String basePath : basePaths) {
            list.add(new File(basePath, "rb/scripts").getPath());
        }
        return list;
    }

    @TestOnly
    public static void addScriptBasePathForClass(@NotNull Class<?> clazz) {
        String jarPath;
        if (clazz == null) {
            RubyUtil.$$$reportNull$$$0(4);
        }
        if ((jarPath = PathUtil.getJarPathForClass(clazz)).endsWith(".jar")) {
            KNOWN_RUBY_ROOTS.add(Path.of(PathManager.getHomePath(), "ruby/tests/src").toString());
            KNOWN_RUBY_ROOTS.add(Path.of(PathManager.getHomePath(), "ruby/tests/resources").toString());
        } else {
            KNOWN_RUBY_ROOTS.add(jarPath);
        }
    }

    static {
        if (PluginManagerCore.isRunningFromSources()) {
            String mainClassPath = PathUtil.getJarPathForClass(RubyUtil.class);
            if (mainClassPath.endsWith(".jar")) {
                Path home = Path.of(PathManager.getHomePath(), new String[0]);
                List.of("ruby/backend/resources", "ruby/backend/rubystubs", "ruby/backend/src", "ruby/backend/gen", "ruby/backend/rubysigs", "contrib/ruby-testing/src", "ruby/coverage/src", "ruby/coverage/resources").forEach(it -> KNOWN_RUBY_ROOTS.add(home.resolve((String)it).toString()));
            } else {
                Path pluginHomePath = Path.of(mainClassPath, new String[0]);
                KNOWN_RUBY_ROOTS.add(mainClassPath);
                KNOWN_RUBY_ROOTS.add(pluginHomePath.getParent().resolve("intellij.ruby.testing").toString());
                KNOWN_RUBY_ROOTS.add(pluginHomePath.getParent().resolve("intellij.ruby.coverage").toString());
            }
        } else {
            Path pluginHomePath = RubyUtil.getRubyPluginHomePath();
            KNOWN_RUBY_ROOTS.add(pluginHomePath.toString());
        }
        KNOWN_RUBY_ROOTS.remove(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/RubyUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyPluginHomePath";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/RubyUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptBasePaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadYaml";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFullPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addScriptBasePathForClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

