/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.UnknownRubyCallType;
import org.jetbrains.plugins.ruby.ruby.run.filters.FileLinksFilterUtil;

@Service(value={Service.Level.PROJECT})
public final class RubyPsiManager
implements Disposable {
    private final List<Pair<PsiElement, ChangesWatcher>> myChangeWatchers;
    private final List<ChangesWatcher> myOutOfCodeBlockModificationWatchers;

    public static RubyPsiManager getInstance(@NotNull Project project) {
        if (project == null) {
            RubyPsiManager.$$$reportNull$$$0(0);
        }
        return (RubyPsiManager)project.getService(RubyPsiManager.class);
    }

    public RubyPsiManager(@NotNull Project project) {
        if (project == null) {
            RubyPsiManager.$$$reportNull$$$0(1);
        }
        this.myChangeWatchers = new CopyOnWriteArrayList<Pair<PsiElement, ChangesWatcher>>();
        this.myOutOfCodeBlockModificationWatchers = new CopyOnWriteArrayList<ChangesWatcher>();
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new MyTreeChangeListener(), (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(this){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileLinksFilterUtil.clearFileCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/ruby/RubyPsiManager$1", "after"));
            }
        });
    }

    public void addChangeWatcher(@Nullable PsiElement parent, @NotNull ChangesWatcher runnable) {
        if (runnable == null) {
            RubyPsiManager.$$$reportNull$$$0(2);
        }
        this.myChangeWatchers.add((Pair<PsiElement, ChangesWatcher>)Pair.create((Object)parent, (Object)runnable));
    }

    public void addOutOfCodeBlockChangeWatcher(@NotNull ChangesWatcher runnable) {
        if (runnable == null) {
            RubyPsiManager.$$$reportNull$$$0(3);
        }
        this.myOutOfCodeBlockModificationWatchers.add(runnable);
    }

    boolean acceptsEvent(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            RubyPsiManager.$$$reportNull$$$0(4);
        }
        return event.getFile() instanceof RFile;
    }

    public boolean isOutOfCodeBlock(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiManager.$$$reportNull$$$0(5);
        }
        if (!element.isValid()) {
            return false;
        }
        if (element instanceof PsiDirectory) {
            return false;
        }
        if (element instanceof PsiFileSystemItem) {
            return true;
        }
        while (!(element instanceof RClass || element instanceof RModule || element instanceof RName || element instanceof RTopLevelContainer)) {
            if (element instanceof PsiFile || element instanceof PsiDirectory) {
                return false;
            }
            if (element instanceof RCall) {
                return ((RCall)element).getCallType() != UnknownRubyCallType.INSTANCE;
            }
            if (element instanceof RCodeBlock) {
                RPossibleCall possibleCall;
                RBlockCall blockCall = ((RCodeBlock)element).getBlockCall();
                RPossibleCall rPossibleCall = possibleCall = blockCall != null ? blockCall.getCall() : null;
                if (possibleCall instanceof RCall) {
                    return !possibleCall.getCallType().isClosureStatementsInsideCodeBlock();
                }
                return false;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof RMethod) {
                RMethod method = (RMethod)parent;
                return element == method.getArgumentList();
            }
            element = parent;
        }
        return true;
    }

    void onOutOfCodeBlockModification(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            RubyPsiManager.$$$reportNull$$$0(6);
        }
        for (ChangesWatcher watcher : this.myOutOfCodeBlockModificationWatchers) {
            watcher.onChange(event.getParent());
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/RubyPsiManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeWatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addOutOfCodeBlockChangeWatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isOutOfCodeBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onOutOfCodeBlockModification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyTreeChangeListener() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyTreeChangeListener.$$$reportNull$$$0(0);
            }
            this.processChange(event, event.getParent());
        }

        private void processChange(PsiTreeChangeEvent event, PsiElement element) {
            if (element == null || !(element instanceof PsiFileSystemItem) && !RubyPsiManager.this.acceptsEvent(event)) {
                return;
            }
            ArrayList<Pair<PsiElement, ChangesWatcher>> invalidChangeWatchers = new ArrayList<Pair<PsiElement, ChangesWatcher>>();
            for (Pair<PsiElement, ChangesWatcher> entry : RubyPsiManager.this.myChangeWatchers) {
                if (entry.first != null && !((PsiElement)entry.first).isValid()) {
                    invalidChangeWatchers.add(entry);
                    continue;
                }
                if (entry.first != null && !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)entry.first), (PsiElement)element, (boolean)false)) continue;
                ((ChangesWatcher)entry.second).onChange(element);
            }
            RubyPsiManager.this.myChangeWatchers.removeAll(invalidChangeWatchers);
            if (RubyPsiManager.this.isOutOfCodeBlock(element)) {
                RubyPsiManager.this.onOutOfCodeBlockModification(event);
            }
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyTreeChangeListener.$$$reportNull$$$0(1);
            }
            String propName = event.getPropertyName();
            PsiElement element = event.getElement();
            if ((propName.equals("fileName") || propName.equals("directoryName")) && element instanceof PsiFileSystemItem) {
                this.processChange(event, event.getParent());
            }
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyTreeChangeListener.$$$reportNull$$$0(2);
            }
            this.processChange(event, event.getOldParent());
            this.processChange(event, event.getNewParent());
            this.processChange(event, event.getParent());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyTreeChangeListener.$$$reportNull$$$0(3);
            }
            this.processChange(event, event.getOldParent());
            this.processChange(event, event.getNewParent());
            this.processChange(event, event.getParent());
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyTreeChangeListener.$$$reportNull$$$0(4);
            }
            this.processChange(event, event.getParent());
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyTreeChangeListener.$$$reportNull$$$0(5);
            }
            this.processChange(event, event.getOldParent());
            this.processChange(event, event.getNewParent());
            this.processChange(event, event.getParent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/RubyPsiManager$MyTreeChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface ChangesWatcher {
        public void onChange(PsiElement var1);
    }
}

