/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RubyFileSystemUtil {
    private static final Logger LOG = Logger.getInstance(RubyFileSystemUtil.class);

    private RubyFileSystemUtil() {
    }

    public static void addRootToWatch(@NotNull String rootPath, boolean watchRecursively, @NotNull Disposable disposable) {
        LocalFileSystem localFileSystem;
        LocalFileSystem.WatchRequest request;
        if (rootPath == null) {
            RubyFileSystemUtil.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            RubyFileSystemUtil.$$$reportNull$$$0(1);
        }
        if ((request = (localFileSystem = LocalFileSystem.getInstance()).addRootToWatch(rootPath, watchRecursively)) != null) {
            Disposer.register((Disposable)disposable, () -> localFileSystem.removeWatchedRoot(request));
        }
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String tryResolveShortWindowsName(@Nullable String path) {
        try {
            return path != null ? FileUtil.resolveShortWindowsName((String)path) : null;
        }
        catch (IOException e) {
            LOG.error("Failed to resolve the short windows path: " + path, (Throwable)e);
            return path;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rootPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "disposable";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/RubyFileSystemUtil";
        objectArray[2] = "addRootToWatch";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

