/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.references;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDUtil;
import org.jetbrains.plugins.ruby.rdoc.yard.references.YARDDocumentationParameterReference;
import org.jetbrains.plugins.ruby.rdoc.yard.references.YARDParameterReference;
import org.jetbrains.plugins.ruby.rdoc.yard.references.YARDQualifiedReference;
import org.jetbrains.plugins.ruby.rdoc.yard.references.YARDReference;
import org.jetbrains.plugins.ruby.rdoc.yard.references.YARDTopLevelReference;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDMethodDirective;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyPolyVariantReferenceBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class YARDReferenceProvider
extends PsiReferenceProvider {
    private static final TokenSet DELIMITERS = TokenSet.create((IElementType[])new IElementType[]{RDocTokenTypes.HASH, RDocTokenTypes.DELIMITER});
    private static final Set<String> STRINGS = Set.of("see", "look", "more");
    private static YARDReferenceProvider ourInstance;

    private YARDReferenceProvider() {
    }

    public static YARDReferenceProvider getInstance() {
        if (ourInstance == null) {
            ourInstance = new YARDReferenceProvider();
        }
        return ourInstance;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            YARDReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            YARDReferenceProvider.$$$reportNull$$$0(1);
        }
        RPsiElement realContainer = YARDUtil.getContainerByYARDComment(element);
        YARDTag docContainer = YARDUtil.getDocContainerByYARDComment(element);
        String text = element.getText();
        boolean paramSeen = text.contains(RDocTokenTypes.PARAM.toString());
        boolean returnSeen = text.contains(RDocTokenTypes.RETURN.toString());
        boolean typeSeen = text.contains(RDocTokenTypes.TYPE_TAG.toString());
        if (realContainer == null && docContainer == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                YARDReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (realContainer == null) {
            realContainer = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RContainer.class);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        List<Pair<IElementType, TextRange>> lexerInfo = YARDUtil.getLexerInfo(text);
        RubyPolyVariantReferenceBase previousTypeReference = null;
        RubyPolyVariantReferenceBase previousTagReference = null;
        IElementType previousElementType = null;
        for (int i = 0; i < lexerInfo.size(); ++i) {
            Pair<IElementType, TextRange> pair = lexerInfo.get(i);
            IElementType elementType = (IElementType)pair.getFirst();
            TextRange range = (TextRange)pair.getSecond();
            if (paramSeen && elementType == RDocTokenTypes.PARAM_NAME) {
                if (docContainer instanceof YARDMethodDirective) {
                    result.add((Object)new YARDDocumentationParameterReference(element, range, (YARDMethodDirective)docContainer));
                }
                if (realContainer instanceof RMethod) {
                    result.add((Object)new YARDParameterReference(element, range, (RMethod)realContainer));
                }
            }
            if (realContainer == null) continue;
            if (paramSeen || returnSeen || typeSeen) {
                if (elementType == RDocTokenTypes.TYPE) {
                    previousTypeReference = previousTypeReference != null ? new YARDQualifiedReference(element, (RPsiPolyVariantReference)((Object)previousTypeReference), previousTypeReference.getCanonicalText(), range, false) : new YARDReference(element, range, realContainer, true);
                    result.add(previousTypeReference);
                } else if (elementType == RDocTokenTypes.COLON2) {
                    if (previousTypeReference == null) {
                        previousTypeReference = new YARDTopLevelReference(element, realContainer);
                    }
                } else {
                    previousTypeReference = null;
                }
            }
            boolean isUppercased = Character.isUpperCase(text.charAt(range.getStartOffset()));
            if (elementType == RDocTokenTypes.CID) {
                Pair<IElementType, TextRange> prevPair;
                if (previousTagReference != null) {
                    previousTagReference = new YARDQualifiedReference(element, (RPsiPolyVariantReference)((Object)previousTagReference), previousTagReference.getCanonicalText(), range, isUppercased);
                } else if (previousElementType == RDocTokenTypes.HASH) {
                    previousTagReference = new YARDReference(element, range, realContainer, false);
                } else if (i != lexerInfo.size() - 1 && RDocTokenTypes.HASH == lexerInfo.get(i + 1).getFirst() && isUppercased) {
                    previousTagReference = new YARDReference(element, range, realContainer, true);
                } else if (previousElementType == RDocTokenTypes.WHITESPACE && i > 1 && (prevPair = lexerInfo.get(i - 2)).getFirst() == RDocTokenTypes.CID && STRINGS.contains(((TextRange)prevPair.getSecond()).substring(text))) {
                    previousTagReference = new YARDReference(element, range, realContainer, isUppercased);
                }
                if (previousTagReference != null) {
                    result.add(previousTagReference);
                }
            } else if (!DELIMITERS.contains(elementType)) {
                previousTagReference = null;
            }
            previousElementType = elementType;
        }
        PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            YARDReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/references/YARDReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/references/YARDReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

