/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.model.impl;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.symbol.SearchTargetSymbol;
import com.intellij.model.Pointer;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.symbol.RenameableSymbol;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.rdoc.yard.model.YardSymbol;
import org.jetbrains.plugins.ruby.rdoc.yard.model.navigation.YardPsiFileRangeNavigationTarget;
import org.jetbrains.plugins.ruby.rdoc.yard.model.psi.index.YardMacroDescriptionsIndex;
import org.jetbrains.plugins.ruby.rdoc.yard.model.psi.index.YardMacroNamesIndex;
import org.jetbrains.plugins.ruby.rdoc.yard.model.usages.YardMacroSearchRenameTarget;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationUtil;

public final class YardMacroSymbol
implements YardSymbol,
NavigatableSymbol,
PresentableSymbol,
RenameableSymbol,
SearchTargetSymbol {
    @NlsSafe
    private final String myName;

    public YardMacroSymbol(@NlsSafe @NotNull String name) {
        if (name == null) {
            YardMacroSymbol.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NotNull
    public Pointer<YardMacroSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            YardMacroSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myName.equals(((YardMacroSymbol)obj).myName);
    }

    @RequiresReadLock
    @NotNull
    public List<String> getData(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            YardMacroSymbol.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            YardMacroSymbol.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.softAssertReadAccess();
        ArrayList<String> data = new ArrayList<String>();
        FileBasedIndex.getInstance().processValues(YardMacroDescriptionsIndex.KEY, (Object)this.myName, null, (file, description) -> {
            data.addAll(List.of(description.split("\n")));
            return false;
        }, GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)searchScope, (Project)project));
        List<String> list = RubyDocumentationUtil.cutCommonIndent(data);
        if (list == null) {
            YardMacroSymbol.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            YardMacroSymbol.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            YardMacroSymbol.$$$reportNull$$$0(6);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        ArrayList targets = new ArrayList();
        FileBasedIndex.getInstance().processValues(YardMacroNamesIndex.KEY, (Object)this.myName, null, (file, ranges) -> {
            ProgressManager.checkCanceled();
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return true;
            }
            for (TextRange range : ranges) {
                targets.add(new YardPsiFileRangeNavigationTarget(psiFile, range, TargetPresentationUtil.createTargetPresentation(this, (PsiElement)psiFile)));
            }
            return true;
        }, maximalSearchScope);
        List list = Collections.unmodifiableList(targets);
        if (list == null) {
            YardMacroSymbol.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public SymbolPresentation getPresentation() {
        Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"yard.model.macro.shortDescription", (Object[])new Object[]{this.myName});
        return new SymbolPresentation(this.myName, shortDescriptionSupplier);
    }

    @NotNull
    public RenameTarget getRenameTarget() {
        return new YardMacroSearchRenameTarget(this);
    }

    @NotNull
    public SearchTarget getSearchTarget() {
        return new YardMacroSearchRenameTarget(this);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @RequiresReadLock
    @NotNull
    public static Optional<YardMacroSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull String name) {
        if (project == null) {
            YardMacroSymbol.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            YardMacroSymbol.$$$reportNull$$$0(9);
        }
        if (name == null) {
            YardMacroSymbol.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.softAssertReadAccess();
        GlobalSearchScope globalSearchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)searchScope, (Project)project);
        if (FileBasedIndex.getInstance().getValues(YardMacroNamesIndex.KEY, (Object)name, globalSearchScope).isEmpty()) {
            Optional<YardMacroSymbol> optional = Optional.empty();
            if (optional == null) {
                YardMacroSymbol.$$$reportNull$$$0(11);
            }
            return optional;
        }
        Optional<YardMacroSymbol> optional = Optional.of(new YardMacroSymbol(name));
        if (optional == null) {
            YardMacroSymbol.$$$reportNull$$$0(12);
        }
        return optional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 7, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/model/impl/YardMacroSymbol";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/model/impl/YardMacroSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 7, 11, 12 -> new IllegalStateException(string);
        };
    }
}

