/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.inspections.RemoveTagQuickfix;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDParamTag;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public class YARDVisitor
extends RubyInspectionVisitor {
    public YARDVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            YARDVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    public void visitRMethod(@NotNull RMethod rMethod) {
        List yardTags;
        if (rMethod == null) {
            YARDVisitor.$$$reportNull$$$0(1);
        }
        if ((yardTags = rMethod.getYARDTags()).isEmpty()) {
            return;
        }
        HashSet<String> paramNames = new HashSet<String>();
        for (ArgumentInfo info : rMethod.getArgumentInfos()) {
            paramNames.add(info.getName());
        }
        HashMap<String, YARDTag> paramsDeclarations = new HashMap<String, YARDTag>();
        for (YARDTag tag : yardTags) {
            if (!(tag instanceof YARDParamTag)) continue;
            YARDParamTag paramTag = (YARDParamTag)tag;
            String name = paramTag.getName();
            if (!paramNames.contains(name)) {
                this.reportErrorWithQuickFix(paramTag, RBundle.message((String)"inspection.yard.wrong.param", (Object[])new Object[]{name}));
            } else {
                YARDTag yardTag = (YARDTag)paramsDeclarations.get(name);
                if (yardTag != null) {
                    this.reportErrorWithQuickFix(paramTag, RBundle.message((String)"inspection.yard.several.param.tags", (Object[])new Object[]{name}));
                }
            }
            paramsDeclarations.put(name, tag);
        }
    }

    private void reportErrorWithQuickFix(YARDParamTag tag, @InspectionMessage String message) {
        RangeInDocumentFakePsiElement element = tag.getTagElement();
        if (element == null) {
            return;
        }
        PsiElement reportElement = element.getParent();
        TextRange reportRange = element.getTextRangeInParent();
        this.myHolder.registerProblem(reportElement, message, ProblemHighlightType.WEAK_WARNING, reportRange, new LocalQuickFix[]{new RemoveTagQuickfix(element.getTextRange())});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMethod";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/YARDVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

