/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;

public class RemoveTagQuickfix
implements LocalQuickFix {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final TextRange myTextRange;

    public RemoveTagQuickfix(@NotNull TextRange textRange) {
        if (textRange == null) {
            RemoveTagQuickfix.$$$reportNull$$$0(0);
        }
        this.myTextRange = textRange;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.yard.remove.tag");
        if (string == null) {
            RemoveTagQuickfix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement;
        if (project == null) {
            RemoveTagQuickfix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RemoveTagQuickfix.$$$reportNull$$$0(3);
        }
        if ((psiElement = descriptor.getPsiElement()) == null) {
            return;
        }
        PsiFile file = psiElement.getContainingFile();
        if (file == null) {
            return;
        }
        PsiElement startComment = file.findElementAt(this.myTextRange.getStartOffset());
        PsiElement endComment = file.findElementAt(this.myTextRange.getEndOffset() - 1);
        if (!(startComment instanceof PsiComment) || !(endComment instanceof PsiComment)) {
            return;
        }
        if (!startComment.getParent().isEquivalentTo(endComment.getParent())) {
            return;
        }
        PsiElement lastElementToDelete = endComment.getNextSibling() instanceof PsiWhiteSpace ? endComment.getNextSibling() : endComment;
        startComment.getParent().deleteChildRange(startComment, lastElementToDelete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/RemoveTagQuickfix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/RemoveTagQuickfix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

