/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDUtil;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDParamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDVariableRelatedTag;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;

public final class MissingYardParamTagInspection
extends LocalInspectionTool {
    public NameTypeOrder myOrder = NameTypeOrder.TYPE_NAME;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MissingYardParamTagInspection.$$$reportNull$$$0(0);
        }
        Object object = !RubyPsiUtil.isRbiFile(holder.getFile()) ? new Visitor(holder, isOnTheFly, this.myOrder) : PsiElementVisitor.EMPTY_VISITOR;
        if (object == null) {
            MissingYardParamTagInspection.$$$reportNull$$$0(1);
        }
        return object;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.dropdown((String)"myOrder", (String)RBundle.message((String)"inspection.missing.yard.param.tag.syntax.format"), NameTypeOrder.class, order -> order == NameTypeOrder.NAME_TYPE ? RBundle.message((String)"inspection.missing.yard.param.tag.name.type") : RBundle.message((String)"inspection.missing.yard.param.tag.type.name"))});
        if (optPane == null) {
            MissingYardParamTagInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardParamTagInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardParamTagInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static enum NameTypeOrder {
        NAME_TYPE,
        TYPE_NAME;

    }

    private static final class Visitor
    extends RubyInspectionVisitor {
        private final NameTypeOrder myOrder;

        private Visitor(@NotNull ProblemsHolder holder, boolean onTheFly, NameTypeOrder order) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, onTheFly);
            this.myOrder = order;
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod method) {
            if (method == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.visitRMethod((RMethod)method);
        }

        public void visitRMethod(@NotNull RMethod method) {
            List<RArgument> toAnnotate;
            if (method == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((toAnnotate = Visitor.getParamsToAnnotate(method)).isEmpty()) {
                return;
            }
            for (RArgument parameter : toAnnotate) {
                if (Optional.ofNullable(parameter.getIdentifier()).map(it -> !it.isMethodParameterDeclaration()).orElse(true).booleanValue()) continue;
                this.registerProblem((PsiElement)parameter, RBundle.message((String)"inspection.missing.yard.param.tag.parameter.not.annotated"), new AddYARDParamTagAnnotationQuickFix(parameter, this.myOrder, false));
            }
            if (this.myOnTheFly) {
                this.registerProblem((PsiElement)ObjectUtils.coalesce((Object)method.getMethodName(), (Object)method), RBundle.message((String)"inspection.missing.yard.param.tag.method.params.not.annotated"), ProblemHighlightType.INFORMATION, new AddYARDParamTagAnnotationQuickFix(toAnnotate, this.myOrder, true));
            }
        }

        private static @Unmodifiable @NotNull List<RArgument> getParamsToAnnotate(@NotNull RMethod method) {
            if (method == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            Set alreadyAnnotated = StreamEx.of((Collection)method.getYARDTags()).select(YARDParamTag.class).map(YARDVariableRelatedTag::getName).toSet();
            List list = ContainerUtil.filter((Collection)method.getArguments(), it -> !alreadyAnnotated.contains(it.getName()));
            if (list == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardParamTagInspection$Visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardParamTagInspection$Visitor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamsToAnnotate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRSingletonMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getParamsToAnnotate";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class AddYARDParamTagAnnotationQuickFix
    implements LocalQuickFix {
        private final List<SmartPsiElementPointer<RArgument>> myParamsToAnnotate;
        private final NameTypeOrder myOrder;
        private final boolean myInvokedOnMethod;

        AddYARDParamTagAnnotationQuickFix(@NotNull List<RArgument> paramsToAnnotate, NameTypeOrder order, boolean invokedOnMethod) {
            if (paramsToAnnotate == null) {
                AddYARDParamTagAnnotationQuickFix.$$$reportNull$$$0(0);
            }
            this.myParamsToAnnotate = ContainerUtil.map(paramsToAnnotate, SmartPointerManager::createPointer);
            this.myOrder = order;
            this.myInvokedOnMethod = invokedOnMethod;
        }

        AddYARDParamTagAnnotationQuickFix(@NotNull RArgument parameter, NameTypeOrder order, boolean invokedOnMethod) {
            if (parameter == null) {
                AddYARDParamTagAnnotationQuickFix.$$$reportNull$$$0(1);
            }
            this(Collections.singletonList(parameter), order, invokedOnMethod);
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            if (target == null) {
                AddYARDParamTagAnnotationQuickFix.$$$reportNull$$$0(2);
            }
            List paramsCopy = ContainerUtil.map(this.myParamsToAnnotate, it -> (RArgument)PsiTreeUtil.findSameElementInCopy((PsiElement)((RArgument)it.getElement()), (PsiFile)target));
            return new AddYARDParamTagAnnotationQuickFix(paramsCopy, this.myOrder, this.myInvokedOnMethod);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myInvokedOnMethod ? RBundle.message((String)"inspection.missing.yard.param.tag.quickfix.name.for.method") : RBundle.message((String)"inspection.missing.yard.param.tag.quickfix.name");
            if (string == null) {
                AddYARDParamTagAnnotationQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RMethod method;
            if (project == null) {
                AddYARDParamTagAnnotationQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                AddYARDParamTagAnnotationQuickFix.$$$reportNull$$$0(5);
            }
            if ((method = RubyPsiUtil.getContainingRMethod(descriptor.getPsiElement())) == null) {
                return;
            }
            Document document = descriptor.getPsiElement().getContainingFile().getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            Optional<Object> editorOptional = EditorFactory.getInstance().editors(document, project).findFirst();
            this.addParameterDescription(project, method, editorOptional.orElse(null));
        }

        private void addParameterDescription(@NotNull Project project, @NotNull RMethod method, @Nullable Editor editor) {
            List<RArgument> toAnnotate;
            if (project == null) {
                AddYARDParamTagAnnotationQuickFix.$$$reportNull$$$0(6);
            }
            if (method == null) {
                AddYARDParamTagAnnotationQuickFix.$$$reportNull$$$0(7);
            }
            if ((toAnnotate = Visitor.getParamsToAnnotate(method)).isEmpty()) {
                return;
            }
            Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
            for (int i = 0; i < this.myParamsToAnnotate.size(); ++i) {
                RArgument psiElement = (RArgument)this.myParamsToAnnotate.get(i).getElement();
                if (psiElement == null) continue;
                String paramType = YARDUtil.transformParameterTypeToYardPresentableString(psiElement);
                List<String> newCommentParts = this.myOrder == NameTypeOrder.NAME_TYPE ? Arrays.asList("# @param " + psiElement.getName() + " [", paramType, "]") : Arrays.asList("# @param [", paramType, "] " + psiElement.getName());
                template.addTextSegment(newCommentParts.get(0));
                template.addVariable((Expression)new ConstantNode(newCommentParts.get(1)), true);
                template.addTextSegment(newCommentParts.get(2));
                template.addTextSegment("\n");
            }
            int startOffset = method.getFirstChild().getTextOffset();
            if (editor != null) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    editor.getCaretModel().moveToOffset(startOffset);
                    TemplateManager.getInstance((Project)project).startTemplate(editor, template);
                });
            } else {
                PsiFile psiFile = method.getContainingFile();
                Document document = psiFile.getViewProvider().getDocument();
                if (document == null) {
                    return;
                }
                String templateText = template.getTemplateText();
                document.insertString(startOffset, (CharSequence)templateText);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)psiFile, startOffset, startOffset + templateText.length());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramsToAnnotate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardParamTagInspection$AddYARDParamTagAnnotationQuickFix";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardParamTagInspection$AddYARDParamTagAnnotationQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addParameterDescription";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

