/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.turbo.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ControllerSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.HelperSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ViewSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolMixinsProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;

public final class RailsTurboSymbolMixinsProvider
implements RubySymbolMixinsProvider {
    private static final FQN TURBO_MODULE_FQN = FQN.of((String)"Turbo");
    private static final FQN TURBO_TAG_BUILDER_FQN = FQN.of((String)"Turbo::Streams::TurboStreamsTagBuilder");
    private static final FQN TURBO_FRAME_REQUEST_FQN = FQN.of((String)"Turbo::Frames::FrameRequest");
    private static final FQN TURBO_NAVIGATION_FQN = FQN.of((String)"Turbo::Native::Navigation");
    private static final FQN TURBO_BROADCASTABLE_FQN = FQN.of((String)"Turbo::Broadcastable");

    @Override
    @NotNull
    public List<? extends Symbol> getImplicitIncludes(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        Symbol turboBroadcastable;
        Project project;
        Symbol turboModule;
        if (symbol == null) {
            RailsTurboSymbolMixinsProvider.$$$reportNull$$$0(0);
        }
        if ((turboModule = SymbolUtil.findConstantByFQN(project = symbol.getProject(), Type.MODULE, TURBO_MODULE_FQN, invocationPoint)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsTurboSymbolMixinsProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        RPsiElement turboModuleElement = (RPsiElement)ObjectUtils.tryCast((Object)turboModule.getPsiElement(), RPsiElement.class);
        if (turboModuleElement == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsTurboSymbolMixinsProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (symbol instanceof ViewSymbol) {
            List<Symbol> list = HelperSymbol.findHelperModules(turboModule, invocationPoint);
            if (list == null) {
                RailsTurboSymbolMixinsProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (symbol instanceof ControllerSymbol) {
            Symbol turboTagBuilderModule = SymbolUtil.lookupConstant(turboModule, (PsiElement)turboModuleElement, TURBO_TAG_BUILDER_FQN, Types.MODULE_OR_CLASS, invocationPoint);
            Symbol turboFrameRequest = SymbolUtil.lookupConstant(turboModule, (PsiElement)turboModuleElement, TURBO_FRAME_REQUEST_FQN, Types.MODULE_OR_CLASS, invocationPoint);
            Symbol turboNavigation = SymbolUtil.lookupConstant(turboModule, (PsiElement)turboModuleElement, TURBO_NAVIGATION_FQN, Types.MODULE_OR_CLASS, invocationPoint);
            if (turboTagBuilderModule != null && turboFrameRequest != null && turboNavigation != null) {
                List<Symbol> list = List.of(turboTagBuilderModule, turboFrameRequest, turboNavigation);
                if (list == null) {
                    RailsTurboSymbolMixinsProvider.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        if (symbol instanceof RailsModelSymbol && (turboBroadcastable = SymbolUtil.lookupConstant(turboModule, (PsiElement)turboModuleElement, TURBO_BROADCASTABLE_FQN, Types.MODULE_OR_CLASS, invocationPoint)) != null) {
            List<Symbol> list = Collections.singletonList(turboBroadcastable);
            if (list == null) {
                RailsTurboSymbolMixinsProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            RailsTurboSymbolMixinsProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/turbo/codeInsight/RailsTurboSymbolMixinsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/turbo/codeInsight/RailsTurboSymbolMixinsProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitIncludes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitIncludes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

