/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.templates;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.newclass.CreateWithTemplatesDialogPanel;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.templates.RailsViewFileTemplateProvider;
import org.jetbrains.plugins.ruby.ruby.templates.RubyCreateFileFromTemplateDialog;
import org.jetbrains.plugins.ruby.statistic.RubyCreateFileFromTemplateCollector;

public final class RailsCreateViewFileDialog {
    public static final String DEFAULT_TEMPLATE_PROPERTY = "RailsCreateViewFileDialog.DEFAULT_TEMPLATE";

    private RailsCreateViewFileDialog() {
    }

    @NotNull
    public static RubyCreateFileFromTemplateDialog.Builder builder(@NotNull Project project, @NotNull String filename) {
        if (project == null) {
            RailsCreateViewFileDialog.$$$reportNull$$$0(0);
        }
        if (filename == null) {
            RailsCreateViewFileDialog.$$$reportNull$$$0(1);
        }
        RubyCreateFileFromTemplateDialog.Builder builder2 = RubyCreateFileFromTemplateDialog.builder(project).setTitle(RBundle.message((String)"rails.createViewFile.dialog.title")).setInputSuggester(RailsCreateViewFileDialog.inputSuggester(filename));
        TreeSet<CreateWithTemplatesDialogPanel.TemplatePresentation> templates = new TreeSet<CreateWithTemplatesDialogPanel.TemplatePresentation>(Comparator.comparing(CreateWithTemplatesDialogPanel.TemplatePresentation::kind));
        for (RailsViewFileTemplateProvider extension : RailsViewFileTemplateProvider.EP_NAME.getExtensionList()) {
            templates.addAll(extension.getTemplates(project));
        }
        templates.forEach(builder2::addKind);
        RubyCreateFileFromTemplateDialog.Builder builder3 = builder2;
        if (builder3 == null) {
            RailsCreateViewFileDialog.$$$reportNull$$$0(2);
        }
        return builder3;
    }

    @NotNull
    public static CreateFileFromTemplateDialog.FileCreator<? extends PsiFile> fileCreator(final @NotNull Project project, final @NotNull VirtualFile root) {
        if (project == null) {
            RailsCreateViewFileDialog.$$$reportNull$$$0(3);
        }
        if (root == null) {
            RailsCreateViewFileDialog.$$$reportNull$$$0(4);
        }
        return new CreateFileFromTemplateDialog.FileCreator<PsiFile>(){

            @Nullable
            public PsiFile createFile(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (templateName == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate(templateName);
                PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(root);
                if (directory == null) {
                    return null;
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    template.setReformatCode(false);
                }
                RubyCreateFileFromTemplateCollector.logCreatedEvent(template);
                return CreateFileFromTemplateAction.createFileFromTemplate((String)name, (FileTemplate)template, (PsiDirectory)directory, (String)RailsCreateViewFileDialog.DEFAULT_TEMPLATE_PROPERTY, (boolean)true);
            }

            @NotNull
            public String getActionName(@NotNull String templateName, @NotNull String name) {
                if (templateName == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (name == null) {
                    1.$$$reportNull$$$0(3);
                }
                String string = RBundle.message((String)"rails.createViewFile.action.name", (Object[])new Object[]{name.substring(name.lastIndexOf("/") + 1)});
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "templateName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/rails/templates/RailsCreateViewFileDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/templates/RailsCreateViewFileDialog$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createFile";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getActionName";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static RubyCreateFileFromTemplateDialog.InputSuggester inputSuggester(final @NotNull String filename) {
        if (filename == null) {
            RailsCreateViewFileDialog.$$$reportNull$$$0(5);
        }
        final HashMap<String, String> templateLanguageExtensions = new HashMap<String, String>();
        for (RailsViewFileTemplateProvider extension : RailsViewFileTemplateProvider.EP_NAME.getExtensionList()) {
            templateLanguageExtensions.putAll(extension.getDefaultTemplateLanguageExtensions());
        }
        return new RubyCreateFileFromTemplateDialog.InputSuggester(){

            @Override
            @NotNull
            public String getSuggestion(@NotNull String templateName) {
                if (templateName == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (templateLanguageExtensions.containsKey(templateName)) {
                    String string = "%s.%s".formatted(filename, templateLanguageExtensions.get(templateName));
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = filename;
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "templateName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/rails/templates/RailsCreateViewFileDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/templates/RailsCreateViewFileDialog$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSuggestion";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getSuggestion";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/templates/RailsCreateViewFileDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/templates/RailsCreateViewFileDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileCreator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inputSuggester";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

