/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.structure;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.structure.RailsRoutesStructureViewElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyFileStructureViewProvider;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewModel;

public final class RailsRoutesStructureViewProvider
implements RubyFileStructureViewProvider {
    @Override
    @Nullable
    public StructureViewBuilder createStructureViewBuilder(final @NotNull RFile file) {
        Module module;
        if (file == null) {
            RailsRoutesStructureViewProvider.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)file)) == null) {
            return null;
        }
        VirtualFile vFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)file);
        if (vFile == null) {
            return null;
        }
        RailsPaths paths = RailsPaths.getInstance(module);
        boolean isRoutesFile = ContainerUtil.exists(paths.findFiles("config/routes.rb"), routesFile -> routesFile.equals(vFile));
        boolean isInRoutesDirectory = VfsUtilCore.isUnderFiles((VirtualFile)vFile, paths.findFiles("config/routes"));
        if (!isRoutesFile && !isInRoutesDirectory) {
            return null;
        }
        return new TreeBasedStructureViewBuilder(this){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new RubyStructureViewModel(this, file, editor){

                    @Override
                    @NotNull
                    public StructureViewTreeElement getRoot() {
                        return new RailsRoutesStructureViewElement((RPsiElement)this.getPsiFile());
                    }
                };
            }

            public boolean isRootNodeShown() {
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/rails/structure/RailsRoutesStructureViewProvider", "createStructureViewBuilder"));
    }
}

